/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.share;

import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSetParser;
import java.util.Vector;

public class ResponseSet {
    static final String QUOTE = "\"";
    static final String NL = "\n";
    static final String BEGIN_CDATA = "<![CDATA[";
    static final String END_CDATA = "]]>";
    private String responseSetVersion = null;
    private String serviceID = null;
    private String requestSetID = null;
    private Vector responseVector = new Vector();

    public ResponseSet(String service) {
        this.serviceID = service;
        this.responseSetVersion = "1.0";
    }

    ResponseSet() {
    }

    public static ResponseSet parseXML(String xml) {
        ResponseSetParser parser = new ResponseSetParser(xml);
        return parser.parseXML();
    }

    public void setRequestSetID(String id) {
        this.requestSetID = id;
    }

    public Vector getResponses() {
        return this.responseVector;
    }

    public void addResponse(Response response) {
        this.responseVector.addElement(response);
    }

    public String toXMLString() {
        StringBuffer xml = new StringBuffer(300);
        xml.append("<?xml version=").append(QUOTE).append("1.0").append(QUOTE).append(" encoding=").append(QUOTE).append("UTF-8").append(QUOTE).append(" standalone=").append(QUOTE).append("yes").append(QUOTE).append("?>").append(NL);
        xml.append("<ResponseSet vers=").append(QUOTE).append(this.responseSetVersion).append(QUOTE).append(" svcid=").append(QUOTE).append(this.serviceID).append(QUOTE).append(" reqid=").append(QUOTE).append(this.requestSetID).append(QUOTE).append(">").append(NL);
        for (int i = 0; i < this.responseVector.size(); ++i) {
            Response res = (Response)this.responseVector.elementAt(i);
            xml.append("<Response");
            if (res.getDtdID() != null) {
                xml.append(" dtdid=").append(QUOTE).append(res.getDtdID()).append(QUOTE);
            }
            xml.append(">");
            xml.append(BEGIN_CDATA).append(res.getContent()).append(END_CDATA);
            xml.append("</Response>").append(NL);
        }
        xml.append("</ResponseSet>");
        return xml.toString();
    }

    void setResponseSetVersion(String ver) {
        this.responseSetVersion = ver;
    }

    void setServiceID(String id) {
        this.serviceID = id;
    }
}

