/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.share;

import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSetParser;
import java.util.Vector;

public class RequestSet {
    static final String QUOTE = "\"";
    static final String NL = "\n";
    static final String BEGIN_CDATA = "<![CDATA[";
    static final String END_CDATA = "]]>";
    private String requestSetVersion = null;
    private String serviceID = null;
    private String requestSetID = null;
    private Vector requestVector = new Vector();
    private static int requestCount = 0;

    public RequestSet(String service) {
        this.serviceID = service;
        this.requestSetVersion = "1.0";
        this.requestSetID = Integer.toString(requestCount++);
    }

    RequestSet() {
    }

    public static RequestSet parseXML(String xml) {
        RequestSetParser parser = new RequestSetParser(xml);
        return parser.parseXML();
    }

    public String getRequestSetVersion() {
        return this.requestSetVersion;
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public String getRequestSetID() {
        return this.requestSetID;
    }

    public Vector getRequests() {
        return this.requestVector;
    }

    public void addRequest(Request request) {
        this.requestVector.addElement(request);
    }

    public String toXMLString() {
        StringBuffer xml = new StringBuffer(300);
        xml.append("<?xml version=").append(QUOTE).append("1.0").append(QUOTE).append(" encoding=").append(QUOTE).append("UTF-8").append(QUOTE).append(" standalone=").append(QUOTE).append("yes").append(QUOTE).append("?>").append(NL);
        xml.append("<RequestSet vers=").append(QUOTE).append(this.requestSetVersion).append(QUOTE).append(" svcid=").append(QUOTE).append(this.serviceID).append(QUOTE).append(" reqid=").append(QUOTE).append(this.requestSetID).append(QUOTE).append(">").append(NL);
        int numRequests = this.requestVector.size();
        for (int i = 0; i < numRequests; ++i) {
            Request req = (Request)this.requestVector.elementAt(i);
            xml.append("<Request");
            if (req.getDtdID() != null) {
                xml.append(" dtdid=").append(QUOTE).append(req.getDtdID()).append(QUOTE);
            }
            if (req.getSessionID() != null) {
                xml.append(" sid=").append(QUOTE).append(req.getSessionID()).append(QUOTE);
            }
            xml.append(">");
            xml.append(BEGIN_CDATA).append(req.getContent()).append(END_CDATA);
            xml.append("</Request>").append(NL);
        }
        xml.append("</RequestSet>");
        return xml.toString();
    }

    void setRequestSetVersion(String vers) {
        this.requestSetVersion = vers;
    }

    void setServiceID(String id) {
        this.serviceID = id;
    }

    void setRequestSetID(String id) {
        this.requestSetID = id;
    }
}

