/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.services.cdm.CDMBundle;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientDetectionException;
import com.iplanet.services.cdm.ClientDetectionInterface;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.services.cdm.DefaultClientTypesManager;
import com.sun.identity.shared.debug.Debug;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class ClientDetectionDefaultImpl
implements ClientDetectionInterface {
    protected static Debug debug = Debug.getInstance("amClientDetection");
    protected static DefaultClientTypesManager defCTM = (DefaultClientTypesManager)AMClientDetector.getClientTypesManagerInstance();

    public String getClientType(HttpServletRequest request) throws ClientDetectionException {
        String httpUA = request.getHeader("user-agent");
        String clientType = null;
        int prevClientUALen = 0;
        if (debug.messageEnabled()) {
            debug.message("UserAgent : httpUA is : " + httpUA);
            debug.message("Looking in UA/PartialMatch Maps");
        }
        Client clientInstance = null;
        clientInstance = defCTM.getFromUserAgentMap(httpUA);
        if (clientInstance != null) {
            clientType = clientInstance.getClientType();
            if (debug.messageEnabled()) {
                debug.message("Perf: from UA Map: " + clientType);
            }
            return clientType;
        }
        clientType = defCTM.getPartiallyMatchedClient(httpUA);
        if (clientType != null) {
            if (debug.messageEnabled()) {
                debug.message("Perf: from PartialMatch Map: " + clientType);
            }
            return clientType;
        }
        int i = 0;
        Iterator knownClients = ClientsManager.getAllInstances();
        while (knownClients.hasNext()) {
            clientInstance = (Client)knownClients.next();
            ++i;
            String curClientUA = clientInstance.getProperty("userAgent");
            if (curClientUA == null) continue;
            if (debug.messageEnabled()) {
                debug.message("(" + i + ") Client user-agent = " + curClientUA + " :: clientType = " + clientInstance.getClientType());
            }
            if (!this.userAgentCheck(httpUA, curClientUA)) continue;
            String curClientType = clientInstance.getProperty("clientType");
            int curClientUALen = curClientUA.length();
            if (curClientUALen <= prevClientUALen) continue;
            clientType = curClientType;
            prevClientUALen = curClientUALen;
            if (!debug.messageEnabled()) continue;
            debug.message("Longest user-agent match client type = " + clientType);
        }
        if (clientType == null) {
            clientType = Client.getDefaultInstance().getProperty("clientType");
            if (debug.messageEnabled()) {
                debug.message("Default client type = " + clientType);
            }
        } else {
            defCTM.addToPartialMatchMap(httpUA, clientType);
        }
        if (clientType == null) {
            debug.message("Unable to obtain default client type");
            throw new ClientDetectionException(CDMBundle.getString("null_clientType"));
        }
        if (debug.messageEnabled()) {
            debug.message("Returning client type : " + clientType);
        }
        return clientType;
    }

    protected boolean userAgentCheck(String httpUA, String clientUA) {
        if (httpUA == null || clientUA == null) {
            return false;
        }
        return httpUA.equalsIgnoreCase(clientUA) || httpUA.indexOf(clientUA) > -1;
    }
}

