/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.DerInputStream;
import com.iplanet.security.util.DerOutputStream;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.util.ObjectIdentifier;
import com.iplanet.security.x509.AVA;
import com.iplanet.security.x509.DirStrConverter;
import com.iplanet.security.x509.GeneralNameInterface;
import com.iplanet.security.x509.LdapDNStrConverter;
import com.iplanet.security.x509.PrintableConverter;
import com.iplanet.security.x509.RDN;
import com.iplanet.security.x509.X500NameAttrMap;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;

public class X500Name
implements Principal,
GeneralNameInterface {
    private String dn;
    private RDN[] names;
    public static final ObjectIdentifier commonName_oid = X500NameAttrMap.getDefault().getOid("CN");
    public static final ObjectIdentifier countryName_oid = X500NameAttrMap.getDefault().getOid("C");
    public static final ObjectIdentifier localityName_oid = X500NameAttrMap.getDefault().getOid("L");
    public static final ObjectIdentifier orgName_oid = X500NameAttrMap.getDefault().getOid("O");
    public static final ObjectIdentifier orgUnitName_oid = X500NameAttrMap.getDefault().getOid("OU");
    public static final ObjectIdentifier stateName_oid = X500NameAttrMap.getDefault().getOid("ST");
    public static final ObjectIdentifier streetAddress_oid = X500NameAttrMap.getDefault().getOid("STREET");
    public static final ObjectIdentifier title_oid = X500NameAttrMap.getDefault().getOid("TITLE");
    public static final ObjectIdentifier email_oid = X500NameAttrMap.getDefault().getOid("E");
    private static final int[] ipAddress_data = new int[]{1, 3, 6, 1, 4, 1, 42, 2, 11, 2, 1};
    public static final ObjectIdentifier ipAddress_oid = new ObjectIdentifier(ipAddress_data);

    public X500Name(String ldapDNString) throws IOException {
        X500Name x500name = LdapDNStrConverter.getDefault().parseDN(ldapDNString);
        this.names = x500name.getNames();
    }

    public X500Name(String ldapDNString, byte[] tags) throws IOException {
        X500Name x500name = LdapDNStrConverter.getDefault().parseDN(ldapDNString, tags);
        this.names = x500name.getNames();
    }

    public X500Name(String ldapDNString, LdapDNStrConverter ldapDNStrConverter) throws IOException {
        X500Name x500name = ldapDNStrConverter.parseDN(ldapDNString);
        this.names = x500name.getNames();
    }

    public X500Name(String commonName, String organizationUnit, String organizationName, String country) throws IOException {
        DirStrConverter dirStrConverter = new DirStrConverter();
        PrintableConverter printableConverter = new PrintableConverter();
        AVA[] assertion = new AVA[1];
        int i = 4;
        this.names = new RDN[i];
        assertion[0] = new AVA(commonName_oid, dirStrConverter.getValue(commonName));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(orgUnitName_oid, dirStrConverter.getValue(organizationUnit));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(orgName_oid, dirStrConverter.getValue(organizationName));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(countryName_oid, printableConverter.getValue(country));
        this.names[--i] = new RDN(assertion);
    }

    public X500Name(String commonName, String organizationUnit, String organizationName, String localityName, String stateName, String country) throws IOException {
        DirStrConverter dirStrConverter = new DirStrConverter();
        PrintableConverter printableConverter = new PrintableConverter();
        AVA[] assertion = new AVA[1];
        int i = 6;
        this.names = new RDN[i];
        assertion[0] = new AVA(commonName_oid, dirStrConverter.getValue(commonName));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(orgUnitName_oid, dirStrConverter.getValue(organizationUnit));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(orgName_oid, dirStrConverter.getValue(organizationName));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(localityName_oid, dirStrConverter.getValue(localityName));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(stateName_oid, dirStrConverter.getValue(stateName));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(countryName_oid, printableConverter.getValue(country));
        this.names[--i] = new RDN(assertion);
    }

    public X500Name(DerValue value) throws IOException {
        this(value.toDerInputStream());
    }

    public X500Name(DerInputStream in) throws IOException {
        this.parseDER(in);
    }

    public X500Name(byte[] name) throws IOException {
        DerInputStream in = new DerInputStream(name);
        this.parseDER(in);
    }

    public X500Name(RDN[] rdns) throws IOException {
        this.names = (RDN[])rdns.clone();
    }

    public X500Name(Vector rdnVector) throws IOException {
        int size = rdnVector.size();
        this.names = new RDN[size];
        for (int i = 0; i < size; ++i) {
            this.names[i] = (RDN)rdnVector.elementAt(i);
        }
    }

    public synchronized boolean equals(X500Name other) {
        if (this == other) {
            return true;
        }
        if (this.names.length != other.names.length) {
            return false;
        }
        for (int i = 0; i < this.names.length; ++i) {
            if (this.names[i].equals(other.names[i])) continue;
            return false;
        }
        return true;
    }

    private String getString(DerValue attribute) throws IOException {
        if (attribute == null) {
            return null;
        }
        String value = attribute.getAsString();
        if (value == null) {
            throw new IOException("not a DER string encoding, " + attribute.tag);
        }
        return value;
    }

    public int getType() {
        return 4;
    }

    public String getCountry() throws IOException {
        DerValue attr = this.findAttribute(countryName_oid);
        return this.getString(attr);
    }

    public String getOrganization() throws IOException {
        DerValue attr = this.findAttribute(orgName_oid);
        return this.getString(attr);
    }

    public String getOrganizationalUnit() throws IOException {
        DerValue attr = this.findAttribute(orgUnitName_oid);
        return this.getString(attr);
    }

    public String getCommonName() throws IOException {
        DerValue attr = this.findAttribute(commonName_oid);
        return this.getString(attr);
    }

    public String getLocality() throws IOException {
        DerValue attr = this.findAttribute(localityName_oid);
        return this.getString(attr);
    }

    public String getState() throws IOException {
        DerValue attr = this.findAttribute(stateName_oid);
        return this.getString(attr);
    }

    public String getEmail() throws IOException {
        DerValue attr = this.findAttribute(email_oid);
        if (attr == null) {
            return null;
        }
        return this.getString(attr);
    }

    public String getAttributeValue(String attr) throws IOException {
        ObjectIdentifier oid = X500NameAttrMap.getDefault().getOid(attr);
        return this.getString(this.findAttribute(oid));
    }

    public String toLdapDNString() throws IOException {
        if (this.dn == null) {
            this.generateDN(LdapDNStrConverter.getDefault());
        }
        return this.dn;
    }

    public String toLdapDNString(LdapDNStrConverter ldapDNStrConverter) throws IOException {
        if (this.dn == null) {
            this.generateDN(ldapDNStrConverter);
        }
        return this.dn;
    }

    public String toString() {
        String s;
        try {
            s = this.toLdapDNString();
        }
        catch (IOException e) {
            return null;
        }
        return s;
    }

    public String getName() {
        return this.toString();
    }

    private DerValue findAttribute(ObjectIdentifier attribute) {
        DerValue retval = null;
        for (int i = 0; i < this.names.length && (retval = this.names[i].findAttribute(attribute)) == null; ++i) {
        }
        return retval;
    }

    public Enumeration getRDNs() {
        return new RDNEnumerator();
    }

    public RDN[] getNames() {
        return (RDN[])this.names.clone();
    }

    public int getNamesLength() {
        return this.names.length;
    }

    private void parseDER(DerInputStream in) throws IOException {
        DerValue[] nameseq = in.getSequence(5);
        this.names = new RDN[nameseq.length];
        for (int i = 0; i < nameseq.length; ++i) {
            this.names[i] = new RDN(nameseq[i]);
        }
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i].encode(tmp);
        }
        out.write((byte)48, tmp);
    }

    public byte[] getEncoded() throws IOException {
        if (this.names == null) {
            return null;
        }
        DerOutputStream out = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i].encode(tmp);
        }
        out.write((byte)48, tmp);
        return out.toByteArray();
    }

    private void generateDN(LdapDNStrConverter ldapDNStrConverter) throws IOException {
        this.dn = ldapDNStrConverter.encodeDN(this);
    }

    static ObjectIdentifier intern(ObjectIdentifier oid) throws IOException {
        return X500NameAttrMap.getDefault().getOid(oid);
    }

    private class RDNEnumerator
    implements Enumeration {
        private int index = 0;

        public boolean hasMoreElements() {
            return this.index < X500Name.this.names.length;
        }

        public Object nextElement() {
            if (this.index >= X500Name.this.names.length) {
                return null;
            }
            return X500Name.this.names[this.index++];
        }
    }
}

