/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.ThreadPool;
import com.iplanet.am.util.ThreadPoolException;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.SessionTimedOutException;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.dpro.session.TokenRestrictionFactory;
import com.iplanet.dpro.session.service.AMSessionRepository;
import com.iplanet.dpro.session.service.ClusterStateService;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.PermutationGenerator;
import com.iplanet.dpro.session.service.SessionConfigListener;
import com.iplanet.dpro.session.service.SessionCount;
import com.iplanet.dpro.session.service.SessionMaxStats;
import com.iplanet.dpro.session.service.SessionRepository;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.common.DNUtils;
import com.sun.identity.common.HttpURLConnectionManager;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.delegation.DelegationEvaluator;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.messageid.LogMessageProvider;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.session.util.RestrictedTokenContext;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.stats.Stats;
import com.sun.identity.shared.stats.StatsListener;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpSession;

public class SessionService {
    private static String LOG_PROVIDER;
    private static ThreadPool threadPool;
    static SSOTokenManager ssoManager;
    public static Debug sessionDebug;
    public static int maxSessions;
    private static int numberOfActiveSessions;
    private static String dsameAdminDN;
    private static String dsameAdminPassword;
    public static Stats stats;
    private static SessionMaxStats maxSessionStats;
    private static boolean logStatus;
    private static Logger logger;
    private static Logger errorLogger;
    private static final String amSSOErrorLogFile = "amSSO.error";
    private static final String amSSOLogFile = "amSSO.access";
    private static LogMessageProvider logProvider;
    public static final String SHANDLE_SCHEME_PREFIX = "shandle:";
    private static final String amSessionService = "iPlanetAMSessionService";
    private static final String httpSessionTrackingCookieName;
    private static final String sunAppServerLBRoutingCookieName;
    private static final String httpSessionPropertyName = "DSAMEInternalSession";
    private static final String httpSessionOwnerListPropertyName = "DSAMEInternalSession.ownerList";
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final int DEFAULT_THRESHOLD = 100;
    protected static final String securityCookieName = "DSAMESecurityCookie";
    protected static final String defaultApplicationMaxCachingTime;
    protected static final long applicationMaxCachingTime;
    private static final String SESSION_CONSTRAINT = "iplanet-am-session-enable-session-constraint";
    private static final String DENY_LOGIN_IF_DB_IS_DOWN = "iplanet-am-session-deny-login-if-db-is-down";
    private static final String MAX_WAIT_TIME_FOR_CONSTARINT = "iplanet-am-session-constraint-max-wait-time";
    private static final String BYPASS_CONSTRAINT_ON_TOPLEVEL_ADMINS = "iplanet-am-session-enable-session-constraint-bypass-topleveladmin";
    private static final String CONSTARINT_RESULTING_BEHAVIOR = "iplanet-am-session-constraint-resulting-behavior";
    private static final String DESTROY_OLD_SESSION = "DESTROY_OLD_SESSION";
    private static final String DENY_ACCESS = "DENY_ACCESS";
    private static final String TOP_LEVEL_ADMIN_ROLE = "Top-level Admin Role";
    private static final String IS_SFO_ENABLED = "iplanet-am-session-sfo-enabled";
    private static final String SESSION_STORE_USERNAME = "iplanet-am-session-store-username";
    private static final String SESSION_STORE_PASSWORD = "iplanet-am-session-store-password";
    private static final String CONNECT_MAX_WAIT_TIME = "iplanet-am-session-store-cpl-max-wait-time";
    private static final String JDBC_DRIVER_CLASS = "iplanet-am-session-JDBC-driver-Impl-classname";
    private static final String JDBC_URL = "iplanet-am-session-jdbc-url";
    private static final String MIN_POOL_SIZE = "iplanet-am-session-min-pool-size";
    private static final String MAX_POOL_SIZE = "iplanet-am-session-max-pool-size";
    private static final String PERMISSION_READ = "READ";
    private static final String PERMISSION_MODIFY = "MODIFY";
    private static final String PERMISSION_DELEGATE = "DELEGATE";
    static String sessionStoreUserName;
    static String sessionStorePassword;
    static HashMap clusterMemberMap;
    static int connectionMaxWaitTime;
    static String jdbcDriverClass;
    static String jdbcURL;
    static int minPoolSize;
    static int maxPoolSize;
    static int maxWaitTimeForConstraint;
    private static boolean isPropertyNotificationEnabled;
    protected static Set notificationProperties;
    private static SSOToken adminToken;
    private static boolean returnAppSession;
    public static final String SESSION_SERVICE = "session";
    private SecureRandom secureRandom;
    private Hashtable sessionTable;
    private Set remoteSessionSet;
    private Hashtable sessionHandleTable;
    private Map restrictedTokenMap;
    private String sessionServer;
    private String sessionServerPort;
    private String sessionServerProtocol;
    private String sessionServerURI;
    private String sessionServerID;
    private static SessionService sessionService;
    public static String deploymentURI;
    private static boolean isSessionFailoverEnabled;
    private static boolean isSiteEnabled;
    private static boolean isSessionConstraintEnabled;
    private static boolean denyLoginIfDBIsDown;
    private static boolean bypassConstratintForToplevelAdmin;
    private static int constraintResultingBehavior;
    private String thisSessionServer;
    private String thisSessionServerPortAsString;
    private int thisSessionServerPort;
    private String thisSessionURI;
    private String thisSessionServerProtocol;
    private String thisSessionServerID;
    private String thisSessionServerURL;
    private URL thisSessionServiceURL;
    private static boolean useRemoteSaveMethod;
    private static boolean useInternalRequestRouting;
    private InternalSession authSession;
    private Vector sessionEventURLs;
    private URL sessionServiceID;
    private ClusterStateService clusterStateService;
    private static AMSessionRepository sessionRepository;
    private static boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionService getSessionService() {
        if (!initialized && SystemProperties.isServerMode()) {
            Class clazz = SessionService.class;
            synchronized (clazz) {
                if (sessionService == null) {
                    sessionService = new SessionService();
                    initialized = true;
                }
            }
        }
        return sessionService;
    }

    public static String getHttpSessionTrackingCookieName() {
        return httpSessionTrackingCookieName;
    }

    public Session getAuthenticationSession(String domain, HttpSession httpSession) {
        try {
            if (this.authSession == null) {
                this.authSession = this.getServiceSession(domain, httpSession);
            }
            return this.authSession != null ? Session.getSession(this.authSession.getID()) : null;
        }
        catch (Exception e) {
            sessionDebug.error("Error creating service session", e);
            return null;
        }
    }

    public String getRestrictedTokenId(String masterSid, TokenRestriction restriction) throws SessionException {
        String hostServerID;
        SessionID sid = new SessionID(masterSid);
        if (SessionService.getUseInternalRequestRouting() && !this.isLocalServer(hostServerID = this.getCurrentHostServer(sid))) {
            if (!sessionService.checkServerUp(hostServerID)) {
                hostServerID = this.getCurrentHostServer(sid);
            }
            if (!this.isLocalServer(hostServerID)) {
                String token = this.getRestrictedTokenIdRemotely(Session.getSessionServiceURL(hostServerID), sid, restriction);
                if (token == null) {
                    throw new SessionException(SessionBundle.getString("invalidSessionID") + masterSid);
                }
                return token;
            }
        }
        return this.doGetRestrictedTokenId(sid, restriction);
    }

    String doGetRestrictedTokenId(SessionID masterSid, TokenRestriction restriction) throws SessionException {
        InternalSession session = (InternalSession)this.sessionTable.get(masterSid);
        if (session == null && (session = sessionService.recoverSession(masterSid)) == null) {
            throw new SessionException(SessionBundle.getString("invalidSessionID") + masterSid);
        }
        this.checkSession(session, masterSid);
        SessionID restrictedSid = session.getRestrictedTokenForRestriction(restriction);
        if (restrictedSid == null) {
            restrictedSid = new SessionID(SessionID.makeRelatedSessionID(this.generateEncryptedID(), session.getID()));
            session.addRestrictedToken(restrictedSid, restriction);
            this.restrictedTokenMap.put(restrictedSid, session.getID());
        }
        return restrictedSid.toString();
    }

    private InternalSession getServiceSession(String domain, HttpSession httpSession) {
        try {
            InternalSession session = null;
            session = this.newInternalSession(domain, httpSession, false);
            session.setType(1);
            String adminDN = (String)AccessController.doPrivileged(new AdminDNAction());
            session.setClientID(adminDN);
            session.setClientDomain(domain);
            session.setExpire(false);
            session.setState(1);
            SessionService.incrementActiveSessions();
            return session;
        }
        catch (Exception e) {
            sessionDebug.error("Error creating service session", e);
            return null;
        }
    }

    public InternalSession newInternalSession(String domain, HttpSession httpSession) {
        try {
            return this.newInternalSession(domain, httpSession, true);
        }
        catch (SessionException e) {
            sessionDebug.error("Error creating new session", e);
            return null;
        }
    }

    private InternalSession newInternalSession(String domain, HttpSession httpSession, boolean forceHttpSessionCreation) throws SessionException {
        if (isSessionFailoverEnabled && !SessionService.getUseInternalRequestRouting() && httpSession == null && forceHttpSessionCreation) {
            return this.createSession(domain);
        }
        InternalSession session = null;
        SessionID sid = null;
        sid = this.generateSessionId(domain, httpSession);
        String sessionHandle = SHANDLE_SCHEME_PREFIX + SessionID.makeRelatedSessionID(this.generateEncryptedID(), sid);
        session = new InternalSession(sid);
        session.setSessionHandle(sessionHandle);
        session.setHttpSession(httpSession);
        this.sessionTable.put(sid, session);
        this.sessionHandleTable.put(sessionHandle, session);
        session.setCreationTime();
        session.setLatestAccessTime();
        String amCtxId = Long.toHexString(this.secureRandom.nextLong()) + (isSiteEnabled ? this.thisSessionServerID : this.sessionServerID);
        session.putProperty("AMCtxId", amCtxId);
        session.putProperty(Session.lbCookieName, WebtopNaming.getLBCookieValue(this.getLocalServerID()));
        session.reschedule();
        return session;
    }

    private String generateEncryptedID() {
        String r = Long.toHexString(this.secureRandom.nextLong());
        return (String)AccessController.doPrivileged(new EncodeAction(r + "@" + this.sessionServerID, Crypt.getHardcodedKeyEncryptor()));
    }

    private SessionID generateSessionId(String domain, HttpSession httpSession) throws SessionException {
        HashMap<String, String> ext;
        String encryptedID;
        String sessionID;
        ExtendedSessionID sid;
        String httpSessionId = null;
        do {
            encryptedID = this.generateEncryptedID();
            ext = new HashMap<String, String>();
            ext.put("SI", this.sessionServerID);
            if (!isSiteEnabled) continue;
            ext.put("S1", this.thisSessionServerID);
            if (!isSessionFailoverEnabled) continue;
            ext.put("SK", String.valueOf(this.secureRandom.nextInt()));
        } while (this.sessionTable.get(sid = new ExtendedSessionID(sessionID = SessionID.makeSessionID(encryptedID, ext, httpSessionId), isSiteEnabled ? this.thisSessionServerID : this.sessionServerID, domain)) != null || this.sessionHandleTable.get(sid) != null);
        return sid;
    }

    private static String extractHttpSessionId(HttpSession httpSession) {
        return httpSession.getId();
    }

    InternalSession removeInternalSession(SessionID sid) {
        boolean isSessionStored = true;
        if (sid == null) {
            return null;
        }
        InternalSession session = (InternalSession)this.sessionTable.remove(sid);
        if (session != null) {
            this.remoteSessionSet.remove(sid);
            session.cancel();
            this.removeSessionHandle(session);
            this.removeRestrictedTokens(session);
            isSessionStored = session.getIsISstored();
            if (session.getState() == 1) {
                SessionService.decrementActiveSessions();
                SessionCount.decrementSessionCount((InternalSession)session);
            }
        }
        if (this.isSessionFailoverEnabled() && isSessionStored) {
            if (SessionService.getUseInternalRequestRouting()) {
                try {
                    this.getRepository().delete(sid);
                }
                catch (Exception e) {
                    sessionDebug.error("SessionService : failed deleting session ", e);
                }
            } else {
                this.invalidateHttpSession(sid);
            }
        }
        return session;
    }

    void deleteFromRepository(SessionID sid) {
        if (this.isSessionFailoverEnabled()) {
            try {
                this.getRepository().delete(sid);
            }
            catch (Exception e) {
                sessionDebug.error("SessionService : failed deleting session ", e);
            }
        }
    }

    private void removeRestrictedTokens(InternalSession session) {
        if (session == null) {
            return;
        }
        Object[] tokens = session.getRestrictedTokens();
        for (int i = 0; i < tokens.length; ++i) {
            this.restrictedTokenMap.remove(tokens[i]);
        }
    }

    private void removeSessionHandle(InternalSession session) {
        if (session == null) {
            return;
        }
        String sessionHandle = session.getSessionHandle();
        if (sessionHandle != null) {
            this.sessionHandleTable.remove(sessionHandle);
        }
    }

    public boolean isSessionFailoverEnabled() {
        return isSessionFailoverEnabled;
    }

    public boolean isSessionPresent(SessionID sid) {
        return this.sessionTable.get(sid) != null || this.restrictedTokenMap.get(sid) != null;
    }

    public boolean checkSessionLocal(SessionID sid) throws SessionException {
        if (this.isSessionPresent(sid)) {
            return true;
        }
        if (this.isSessionFailoverEnabled()) {
            String hostServerID = this.getCurrentHostServer(sid);
            if (this.isLocalServer(hostServerID)) {
                if (this.recoverSession(sid) == null) {
                    throw new SessionException(SessionBundle.getString("sessionNotObtained"));
                }
                return true;
            }
        } else {
            return this.isLocalSessionService(Session.getSessionServiceURL(sid));
        }
        return false;
    }

    public boolean isLocalSessionService(URL url) {
        URL localURL = isSiteEnabled ? this.thisSessionServiceURL : this.sessionServiceID;
        return localURL != null && localURL.getProtocol().equalsIgnoreCase(url.getProtocol()) && localURL.getHost().equalsIgnoreCase(url.getHost()) && localURL.getPort() == url.getPort();
    }

    public boolean isLocalServer(String serverID) {
        if (isSiteEnabled) {
            return this.thisSessionServerID.equals(serverID);
        }
        return this.sessionServerID.equals(serverID);
    }

    public boolean isLocalSite(SessionID sid) {
        String siteID = sid.getSessionServerID();
        return this.sessionServerID.equals(siteID);
    }

    public String getLocalServerID() {
        if (isSiteEnabled) {
            return this.thisSessionServerID;
        }
        return this.sessionServerID;
    }

    public InternalSession getInternalSession(SessionID sid) {
        if (sid == null) {
            return null;
        }
        if (sid.toString().startsWith(SHANDLE_SCHEME_PREFIX)) {
            return null;
        }
        InternalSession is = (InternalSession)this.sessionTable.get(sid);
        return is;
    }

    public InternalSession getInternalSessionByHandle(String shandle) {
        return (InternalSession)this.sessionHandleTable.get(shandle);
    }

    private InternalSession resolveToken(SessionID token) throws SessionException {
        InternalSession sess = (InternalSession)this.sessionTable.get(token);
        if (sess == null) {
            sess = this.resolveRestrictedToken(token, true);
        }
        if (sess == null) {
            throw new SessionException(SessionBundle.getString("invalidSessionID") + token.toString());
        }
        return sess;
    }

    private InternalSession resolveRestrictedToken(SessionID token, boolean checkRestriction) throws SessionException {
        SessionID sid = (SessionID)this.restrictedTokenMap.get(token);
        if (sid == null) {
            return null;
        }
        InternalSession session = (InternalSession)this.sessionTable.get(sid);
        if (session == null) {
            this.restrictedTokenMap.remove(token);
            return null;
        }
        if (checkRestriction) {
            try {
                TokenRestriction restriction = session.getRestrictionForToken(token);
                if (restriction != null && !restriction.isSatisfied(RestrictedTokenContext.getCurrent())) {
                    throw new SessionException(SessionBundle.rbName, "restrictionViolation", null);
                }
            }
            catch (SessionException se) {
                throw se;
            }
            catch (Exception e) {
                throw new SessionException(e);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getValidInternalSessions() {
        Vector<InternalSession> sessions = new Vector<InternalSession>();
        Hashtable hashtable = this.sessionTable;
        synchronized (hashtable) {
            Enumeration enumerator = this.sessionTable.elements();
            while (enumerator.hasMoreElements()) {
                InternalSession sess = (InternalSession)enumerator.nextElement();
                if (sess.getState() != 1 || !sess.willExpire() && !returnAppSession) continue;
                sessions.addElement(sess);
            }
        }
        return sessions;
    }

    private Vector getValidInternalSessions(String pattern, int[] status) throws SessionException {
        Vector<InternalSession> sessions = new Vector<InternalSession>();
        if (pattern == null) {
            pattern = "*";
        }
        try {
            long startTime = System.currentTimeMillis();
            pattern = pattern.toLowerCase();
            Vector allValidSessions = this.getValidInternalSessions();
            Enumeration enumerator = allValidSessions.elements();
            boolean matchAll = pattern.equals("*");
            while (enumerator.hasMoreElements()) {
                String clientID;
                InternalSession sess = (InternalSession)enumerator.nextElement();
                if (!matchAll && ((clientID = sess.willExpire() ? DNUtils.DNtoName(sess.getClientID()) : sess.getClientID()) == null || !SessionService.matchFilter(clientID = clientID.toLowerCase(), pattern))) continue;
                if (sessions.size() == SessionConfigListener.getMaxsize()) {
                    status[0] = 1;
                } else {
                    sessions.addElement(sess);
                    if (System.currentTimeMillis() - startTime < SessionConfigListener.getTimeout()) continue;
                    status[0] = 2;
                }
                break;
            }
        }
        catch (Exception e) {
            sessionDebug.error("SessionService : Unable to get Session Information ", e);
            throw new SessionException(e);
        }
        return sessions;
    }

    public void destroyInternalSession(SessionID sid) {
        InternalSession sess = this.removeInternalSession(sid);
        sess.setIsISStored(false);
        if (sess != null && sess.getState() != 0) {
            this.logEvent(sess, 5);
            sess.setState(3);
            this.sendEvent(sess, 5);
        }
    }

    public void logoutInternalSession(SessionID sid) {
        InternalSession sess = this.removeInternalSession(sid);
        sess.setIsISStored(false);
        if (sess != null && sess.getState() != 0) {
            this.logEvent(sess, 3);
            sess.setState(3);
            this.sendEvent(sess, 3);
        }
    }

    public static synchronized void decrementActiveSessions() {
        --numberOfActiveSessions;
    }

    public static synchronized void incrementActiveSessions() {
        ++numberOfActiveSessions;
    }

    public static synchronized int getActiveSessions() {
        return numberOfActiveSessions;
    }

    public static int getNotificationQueueSize() {
        return threadPool.getCurrentSize();
    }

    private void addInternalSessionListener(InternalSession sess, String url, SessionID sid) {
        if (sess != null) {
            if (!sid.equals(sess.getID()) && sess.getRestrictionForToken(sid) == null) {
                throw new IllegalArgumentException("Session id mismatch");
            }
            Map urls = sess.getSessionEventURLs();
            urls.put(url, sid);
            sess.updateForFailover();
        }
    }

    private void addListenerOnAllInternalSessions(String url) {
        if (!this.sessionEventURLs.contains(url)) {
            this.sessionEventURLs.addElement(url);
        }
    }

    public SessionInfo getSessionInfo(SessionID sid, boolean reset) throws SessionException {
        InternalSession sess = this.resolveToken(sid);
        this.checkSession(sess, sid);
        SessionInfo info = this.makeSessionInfo(sess, sid);
        if (reset) {
            sess.setLatestAccessTime();
        }
        return info;
    }

    private SessionInfo makeSessionInfo(InternalSession sess, SessionID sid) throws SessionException {
        SessionInfo info = sess.toSessionInfo();
        TokenRestriction restriction = sess.getRestrictionForToken(sid);
        if (restriction != null) {
            try {
                info.properties.put("TokenRestriction", TokenRestrictionFactory.marshal(restriction));
            }
            catch (Exception e) {
                throw new SessionException(e);
            }
        } else if (!sid.equals(sess.getID())) {
            throw new IllegalArgumentException("Session id mismatch");
        }
        info.sid = sid.toString();
        return info;
    }

    private void checkSession(InternalSession sess, SessionID sid) throws SessionException {
        if (!sid.equals(sess.getID()) && sess.getRestrictionForToken(sid) == null) {
            throw new IllegalArgumentException("Session id mismatch");
        }
        if (sess.getState() != 1) {
            if (sess.getTimeLeftBeforePurge() > 0L) {
                throw new SessionTimedOutException(SessionBundle.getString("sessionTimedOut") + " " + sid);
            }
            throw new SessionException(SessionBundle.getString("invalidSessionState") + " " + sid);
        }
    }

    public Vector getValidSessions(Session s) throws SessionException {
        int[] status = new int[]{0};
        return this.getValidSessions(s, null, status);
    }

    public Vector getValidSessions(Session s, String pattern, int[] status) throws SessionException {
        if (s.getState(false) != 1) {
            throw new SessionException(SessionBundle.getString("invalidSessionState") + s.getID().toString());
        }
        try {
            AMIdentity user = this.getUser(s);
            Set orgList = user.getAttribute("iplanet-am-session-get-valid-sessions");
            if (orgList == null) {
                orgList = Collections.EMPTY_SET;
            }
            Vector sessions = sessionService.getValidInternalSessions(pattern, status);
            int size = sessions.size();
            Vector<SessionInfo> infos = new Vector<SessionInfo>(size);
            boolean isTopLevelAdmin = this.hasTopLevelAdminRole(s);
            for (int i = 0; i < size; ++i) {
                InternalSession sess = (InternalSession)sessions.elementAt(i);
                if (!isTopLevelAdmin && !orgList.contains(sess.getClientDomain())) continue;
                SessionInfo info = sess.toSessionInfo();
                info.sid = sess.getSessionHandle();
                infos.add(info);
            }
            return infos;
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
    }

    public void destroySession(Session s, SessionID sid) throws SessionException {
        if (sid == null) {
            return;
        }
        if (s.getState(false) != 1) {
            throw new SessionException(SessionBundle.getString("invalidSessionState") + sid.toString());
        }
        InternalSession sess = sessionService.getInternalSession(sid);
        if (sess == null) {
            sess = sessionService.getInternalSessionByHandle(sid.toString());
        }
        if (sess != null) {
            sid = sess.getID();
            try {
                if (s.getID().equals(sid) || this.hasTopLevelAdminRole(s)) {
                    sessionService.destroyInternalSession(sid);
                    return;
                }
                AMIdentity user = this.getUser(s);
                Set orgList = user.getAttribute("iplanet-am-session-destroy-sessions");
                if (!orgList.contains(s.getClientDomain())) {
                    throw new SessionException(SessionBundle.rbName, "noPrivilege", null);
                }
                sessionService.destroyInternalSession(sid);
            }
            catch (Exception e) {
                throw new SessionException(e);
            }
        }
    }

    public void logout(SessionID sid) throws SessionException {
        this.locateSession(sid);
        this.logoutInternalSession(sid);
    }

    public void addSessionListener(SessionID sid, String url) throws SessionException {
        InternalSession sess = this.resolveToken(sid);
        if (sess.getState() == 0) {
            throw new SessionException(SessionBundle.getString("invalidSessionState") + sid.toString());
        }
        this.addInternalSessionListener(sess, url, sid);
    }

    public void addSessionListenerOnAllSessions(Session s, String url) throws SessionException {
        if (s.getState(false) != 1) {
            throw new SessionException(SessionBundle.getString("invalidSessionState") + s.getID().toString());
        }
        if (s.getClientID().equals(dsameAdminDN)) {
            this.addListenerOnAllInternalSessions(url);
            return;
        }
        try {
            String value;
            AMIdentity user = this.getUser(s);
            Set values = user.getAttribute("iplanet-am-session-add-session-listener-on-all-sessions");
            String string = value = values != null && !values.isEmpty() ? (String)values.iterator().next() : null;
            if (value == null || value.equals("false")) {
                throw new SessionException(SessionBundle.rbName, "noPrivilege", null);
            }
            this.addListenerOnAllInternalSessions(url);
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
    }

    public void setProperty(SessionID sid, String name, String value) throws SessionException {
        this.locateSession(sid).putProperty(name, value);
    }

    protected InternalSession locateSession(SessionID sid) throws SessionException {
        InternalSession sess = this.getInternalSession(sid);
        if (sess == null) {
            throw new SessionException(SessionBundle.getString("invalidSessionID") + sid.toString());
        }
        return sess;
    }

    public void setExternalProperty(SessionID sid, String name, String value) throws SessionException {
        this.locateSession(sid).putExternalProperty(name, value);
    }

    public void sendEvent(InternalSession sess, int evttype) {
        sessionDebug.message("Running sendEvent, type = " + evttype);
        try {
            SessionNotificationSender sns = new SessionNotificationSender(this, this, sess, evttype);
            if (sns.sendToLocal()) {
                threadPool.run((Runnable)sns);
            }
        }
        catch (ThreadPoolException e) {
            sessionDebug.error("Sending Notification Error: ", e);
        }
    }

    public void logEvent(InternalSession sess, int eventType) {
        switch (eventType) {
            case 0: {
                this.logIt(sess, "SESSION_CREATED");
                break;
            }
            case 1: {
                this.logIt(sess, "SESSION_IDLE_TIMED_OUT");
                break;
            }
            case 2: {
                this.logIt(sess, "SESSION_MAX_TIMEOUT");
                break;
            }
            case 3: {
                this.logIt(sess, "SESSION_LOGOUT");
                break;
            }
            case 4: {
                this.logIt(sess, "SESSION_REACTIVATION");
                break;
            }
            case 5: {
                this.logIt(sess, "SESSION_DESTROYED");
                break;
            }
            case 6: {
                this.logIt(sess, "SESSION_PROPERTY_CHANGED");
                break;
            }
            case 7: {
                this.logIt(sess, "SESSION_QUOTA_EXHAUSTED");
                break;
            }
            default: {
                this.logIt(sess, "SESSION_UNKNOWN_EVENT");
            }
        }
    }

    private Logger getLogger() {
        if (logger == null) {
            logger = (Logger)Logger.getLogger(amSSOLogFile);
        }
        return logger;
    }

    private LogMessageProvider getLogMessageProvider() throws Exception {
        if (logProvider == null) {
            logProvider = MessageProviderFactory.getProvider(LOG_PROVIDER);
        }
        return logProvider;
    }

    public void logIt(InternalSession sess, String id) {
        if (!logStatus) {
            return;
        }
        try {
            StringTokenizer st;
            String sidString = sess.getID().toString();
            String clientID = sess.getClientID();
            String uidData = null;
            uidData = clientID == null || clientID.length() < 1 ? "N/A" : ((st = new StringTokenizer(clientID, ",")).hasMoreTokens() ? st.nextToken() : clientID);
            String[] data = new String[]{uidData};
            LogRecord lr = this.getLogMessageProvider().createLogRecord(id, data, null);
            lr.addLogInfo("LoginIDSid", sidString);
            String amCtxID = sess.getProperty("AMCtxId");
            String clientDomain = sess.getClientDomain();
            String ipAddress = sess.getProperty("Host");
            String hostName = sess.getProperty("HostName");
            lr.addLogInfo("ContextID", amCtxID);
            lr.addLogInfo("LoginID", clientID);
            lr.addLogInfo("LogLevel", lr.getLevel().toString());
            lr.addLogInfo("Domain", clientDomain);
            lr.addLogInfo("IPAddr", ipAddress);
            lr.addLogInfo("HostName", hostName);
            this.getLogger().log(lr, this.getSessionServiceToken());
        }
        catch (Exception ex) {
            sessionDebug.error("SessionService.logIt(): Cannot write to the session log file: ", ex);
        }
    }

    public void logSystemMessage(String msgID, Level level) {
        if (!logStatus) {
            return;
        }
        if (errorLogger == null) {
            errorLogger = (Logger)Logger.getLogger(amSSOErrorLogFile);
        }
        try {
            String[] data = new String[]{msgID};
            LogRecord lr = this.getLogMessageProvider().createLogRecord(msgID, data, null);
            SSOToken serviceToken = this.getSessionServiceToken();
            lr.addLogInfo("LoginIDSid", ((Object)serviceToken.getTokenID()).toString());
            lr.addLogInfo("LoginID", serviceToken.getPrincipal().getName());
            errorLogger.log(lr, serviceToken);
        }
        catch (Exception ex) {
            sessionDebug.error("SessionService.logSystemMessage(): Cannot write to the session error log file: ", ex);
        }
    }

    private SSOTokenManager getSSOTokenManager() throws SSOException {
        if (ssoManager == null) {
            ssoManager = SSOTokenManager.getInstance();
        }
        return ssoManager;
    }

    SSOToken getSessionServiceToken() throws Exception {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }

    private SSOToken getAdminToken() throws SSOException {
        if (adminToken == null) {
            adminToken = this.getSSOTokenManager().createSSOToken((Principal)new AuthPrincipal(dsameAdminDN), dsameAdminPassword);
            return adminToken;
        }
        return adminToken;
    }

    private SessionService() {
        block12: {
            this.secureRandom = null;
            this.sessionTable = null;
            this.remoteSessionSet = null;
            this.sessionHandleTable = new Hashtable();
            this.restrictedTokenMap = Collections.synchronizedMap(new HashMap());
            this.authSession = null;
            this.sessionEventURLs = new Vector();
            this.sessionServiceID = null;
            this.clusterStateService = null;
            try {
                dsameAdminDN = (String)AccessController.doPrivileged(new AdminDNAction());
                dsameAdminPassword = (String)AccessController.doPrivileged(new AdminPasswordAction());
                this.sessionServerProtocol = SystemProperties.get("com.iplanet.am.server.protocol");
                this.sessionServer = SystemProperties.get("com.iplanet.am.server.host");
                this.sessionServerPort = SystemProperties.get("com.iplanet.am.server.port");
                this.sessionServerURI = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
                this.sessionServerID = WebtopNaming.getServerID(this.sessionServerProtocol, this.sessionServer, this.sessionServerPort, this.sessionServerURI);
                isSiteEnabled = WebtopNaming.isSiteEnabled(this.sessionServerProtocol, this.sessionServer, this.sessionServerPort, this.sessionServerURI);
                if (isSiteEnabled) {
                    this.sessionServerID = WebtopNaming.getSiteID(this.sessionServerProtocol, this.sessionServer, this.sessionServerPort, this.sessionServerURI);
                    this.sessionServiceID = new URL(WebtopNaming.getServerFromID(this.sessionServerID));
                    this.sessionServerProtocol = this.sessionServiceID.getProtocol();
                    this.sessionServer = this.sessionServiceID.getHost();
                    this.sessionServerPort = Integer.toString(this.sessionServiceID.getPort());
                } else {
                    this.sessionServiceID = new URL(WebtopNaming.getServerFromID(this.sessionServerID));
                }
                try {
                    this.secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
                }
                catch (NoSuchProviderException e) {
                    this.secureRandom = SecureRandom.getInstance("SHA1PRNG");
                }
                this.sessionTable = new Hashtable();
                this.remoteSessionSet = Collections.synchronizedSet(new HashSet());
                if (stats.isEnabled()) {
                    maxSessionStats = new SessionMaxStats(this.sessionTable);
                    stats.addStatsListener((StatsListener)maxSessionStats);
                }
                this.postInit();
                if (!isSiteEnabled) break block12;
                this.thisSessionServerProtocol = SystemProperties.get("com.iplanet.am.server.protocol");
                this.thisSessionServer = SystemProperties.get("com.iplanet.am.server.host");
                this.thisSessionServerPortAsString = SystemProperties.get("com.iplanet.am.server.port");
                this.thisSessionURI = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
                if (this.thisSessionServerProtocol == null || this.thisSessionServerPortAsString == null || this.thisSessionServer == null || this.thisSessionURI == null) {
                    throw new SessionException(SessionBundle.rbName, "propertyMustBeSet", null);
                }
                this.thisSessionServerPort = Integer.parseInt(this.thisSessionServerPortAsString);
                this.thisSessionServerID = WebtopNaming.getServerID(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPortAsString, this.thisSessionURI);
                this.thisSessionServerURL = this.thisSessionServerProtocol + "://" + this.thisSessionServer + ":" + this.thisSessionServerPortAsString + this.thisSessionURI;
                this.thisSessionServiceURL = Session.getSessionServiceURL(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPortAsString, this.thisSessionURI);
                if (!isSessionFailoverEnabled) break block12;
                int timeout = 1000;
                try {
                    timeout = Integer.parseInt(SystemProperties.get("com.iplanet.am.session.failover.cluster.stateCheck.timeout", String.valueOf(1000)));
                }
                catch (Exception e) {
                    sessionDebug.error("Invalid value for com.iplanet.am.session.failover.cluster.stateCheck.timeout, using default");
                }
                long period = 1000L;
                try {
                    period = Integer.parseInt(SystemProperties.get("com.iplanet.am.session.failover.cluster.stateCheck.period", String.valueOf(1000L)));
                }
                catch (Exception e) {
                    sessionDebug.error("Invalid value for com.iplanet.am.session.failover.cluster.stateCheck.period, using default");
                }
                this.clusterStateService = new ClusterStateService(this, this.thisSessionServerID, timeout, period, (Map)clusterMemberMap);
                this.getRepository();
            }
            catch (Exception ex) {
                sessionDebug.error("SessionService.SessionService(): Initialization Failed", ex);
            }
        }
    }

    public String getCurrentHostServer(SessionID sid) throws SessionException {
        if (!this.isSessionFailoverEnabled()) {
            return sid.getSessionServerID();
        }
        if (SessionService.getUseInternalRequestRouting()) {
            String serverID = this.locateCurrentHostServer(sid);
            if (!this.isLocalServer(serverID)) {
                this.handleReleaseSession(sid);
            }
            return serverID;
        }
        return sid.getSessionServerID();
    }

    private String locateCurrentHostServer(SessionID sid) throws SessionException {
        String primaryID = sid.getExtension("S1");
        String serverID = sid.getSessionServerID();
        if (!serverID.equals(this.sessionServerID)) {
            return serverID;
        }
        if (this.clusterStateService.isUp(primaryID)) {
            return primaryID;
        }
        int selectionListSize = this.clusterStateService.getServerSelectionListSize();
        PermutationGenerator perm = new PermutationGenerator((long)sid.getExtension("SK").hashCode(), selectionListSize);
        String selectedServerId = null;
        for (int i = 0; i < selectionListSize && !this.clusterStateService.isUp(selectedServerId = this.clusterStateService.getServerSelection((int)perm.itemAt(i))); ++i) {
        }
        return selectedServerId;
    }

    public static boolean getUseInternalRequestRouting() {
        if (isSessionFailoverEnabled) {
            return useInternalRequestRouting;
        }
        return false;
    }

    public static boolean isSessionConstraintEnabled() {
        return isSessionConstraintEnabled;
    }

    public static boolean denyLoginIfDBIsDown() {
        return denyLoginIfDBIsDown;
    }

    public static boolean bypassConstratintForToplevelAdmin() {
        return bypassConstratintForToplevelAdmin;
    }

    public static int getConstraintResultingBehavior() {
        return constraintResultingBehavior;
    }

    protected AMSessionRepository getRepository() {
        if (!SessionService.getUseInternalRequestRouting()) {
            return null;
        }
        if (sessionRepository == null) {
            try {
                sessionRepository = SessionRepository.getInstance();
            }
            catch (Exception e) {
                sessionDebug.error("Failed to initialize session repository", e);
            }
        }
        return sessionRepository;
    }

    public boolean checkServerUp(String serverID) {
        return this.clusterStateService.checkServerUp(serverID);
    }

    private void postInit() {
        try {
            Map sessionAttrs;
            boolean sfoEnabled;
            String subCfgName;
            String resultingBehaviorStr;
            String bypassConstratintStr;
            String denyLoginStr;
            String constraintStr;
            ServiceSchemaManager ssm = new ServiceSchemaManager(amSessionService, this.getAdminToken());
            ServiceSchema schema = ssm.getGlobalSchema();
            Map attrs = schema.getAttributeDefaults();
            String notificationStr = CollectionHelper.getMapAttr(attrs, "iplanet-am-session-property-change-notification", "OFF");
            if (notificationStr.equalsIgnoreCase("ON")) {
                isPropertyNotificationEnabled = true;
                notificationProperties = (Set)attrs.get("iplanet-am-session-notification-property-list");
            }
            if ((constraintStr = CollectionHelper.getMapAttr(attrs, SESSION_CONSTRAINT, "OFF")).equalsIgnoreCase("ON")) {
                isSessionConstraintEnabled = true;
            }
            if (sessionDebug.messageEnabled()) {
                sessionDebug.message("isSessionConstraintEnabled=" + isSessionConstraintEnabled);
            }
            if ((denyLoginStr = CollectionHelper.getMapAttr(attrs, DENY_LOGIN_IF_DB_IS_DOWN, "NO")).equalsIgnoreCase("YES")) {
                denyLoginIfDBIsDown = true;
            }
            if (sessionDebug.messageEnabled()) {
                sessionDebug.message("SessionService.postInit: denyLoginIfDBIsDown=" + denyLoginIfDBIsDown);
            }
            if ((bypassConstratintStr = CollectionHelper.getMapAttr(attrs, BYPASS_CONSTRAINT_ON_TOPLEVEL_ADMINS, "NO")).equalsIgnoreCase("YES")) {
                bypassConstratintForToplevelAdmin = true;
            }
            if (sessionDebug.messageEnabled()) {
                sessionDebug.message("bypassConstratintForToplevelAdmin=" + bypassConstratintForToplevelAdmin);
            }
            if ((resultingBehaviorStr = CollectionHelper.getMapAttr(attrs, CONSTARINT_RESULTING_BEHAVIOR, DESTROY_OLD_SESSION)).equalsIgnoreCase(DESTROY_OLD_SESSION)) {
                constraintResultingBehavior = 1;
            } else if (resultingBehaviorStr.equalsIgnoreCase(DENY_ACCESS)) {
                constraintResultingBehavior = 2;
            }
            if (sessionDebug.messageEnabled()) {
                sessionDebug.message("Resulting behavior if session quota exhausted:" + resultingBehaviorStr);
            }
            maxWaitTimeForConstraint = Integer.parseInt(CollectionHelper.getMapAttr(attrs, MAX_WAIT_TIME_FOR_CONSTARINT, "6000"));
            ServiceConfigManager scm = new ServiceConfigManager(amSessionService, this.getAdminToken());
            ServiceConfig serviceConfig = scm.getGlobalConfig(null);
            ServiceConfig subConfig = serviceConfig.getSubConfig(subCfgName = ServerConfiguration.isLegacy(adminToken) ? this.sessionServiceID.toString() : SiteConfiguration.getSiteIdByURL(adminToken, this.sessionServiceID.toString()));
            if (subConfig != null && (sfoEnabled = Boolean.valueOf(CollectionHelper.getMapAttr(sessionAttrs = subConfig.getAttributes(), IS_SFO_ENABLED, "false")).booleanValue())) {
                isSessionFailoverEnabled = true;
                sessionStoreUserName = CollectionHelper.getMapAttr(sessionAttrs, SESSION_STORE_USERNAME, "amsvrusr");
                sessionStorePassword = CollectionHelper.getMapAttr(sessionAttrs, SESSION_STORE_PASSWORD, "password");
                Set serverIDs = WebtopNaming.getSiteNodes(this.sessionServerID);
                this.initClusterMemberMap(serverIDs);
                connectionMaxWaitTime = Integer.parseInt(CollectionHelper.getMapAttr(sessionAttrs, CONNECT_MAX_WAIT_TIME, "5000"));
                jdbcDriverClass = CollectionHelper.getMapAttr(sessionAttrs, JDBC_DRIVER_CLASS, "");
                jdbcURL = CollectionHelper.getMapAttr(sessionAttrs, JDBC_URL, "");
                minPoolSize = Integer.parseInt(CollectionHelper.getMapAttr(sessionAttrs, MIN_POOL_SIZE, "8"));
                maxPoolSize = Integer.parseInt(CollectionHelper.getMapAttr(sessionAttrs, MAX_POOL_SIZE, "32"));
                if (sessionDebug.messageEnabled()) {
                    sessionDebug.message("UserName=" + sessionStoreUserName + " : " + "clusterServerList=" + this.getClusterServerList() + ": " + "connectionMaxWaitTime=" + connectionMaxWaitTime + " :" + "jdbcDriverClass=" + jdbcDriverClass + " : " + "jdcbURL=" + jdbcURL + " : " + "minPoolSize=" + minPoolSize + " : " + "maxPoolSize=" + maxPoolSize);
                }
            }
            if (sessionDebug.messageEnabled()) {
                sessionDebug.message("Session Failover Enabled = " + isSessionFailoverEnabled);
            }
            SessionConfigListener utils = new SessionConfigListener(ssm);
            ssm.addListener((ServiceListener)utils);
            utils.schemaChanged(amSessionService, null);
        }
        catch (Exception ex) {
            sessionDebug.error("SessionService.postInit():+Unable to get Session Schema Information", ex);
        }
    }

    private void initClusterMemberMap(Set serverIDs) throws Exception {
        Iterator m = serverIDs.iterator();
        while (m.hasNext()) {
            String serverID = (String)m.next();
            String serverURL = WebtopNaming.getServerFromID(serverID);
            clusterMemberMap.put(serverID, serverURL);
        }
    }

    private String getClusterServerList() {
        StringBuffer clusterServerList = new StringBuffer();
        Set serverIDs = clusterMemberMap.keySet();
        Iterator m = serverIDs.iterator();
        while (m.hasNext()) {
            String serverID = (String)m.next();
            clusterServerList.append(serverID).append(" ");
        }
        return clusterServerList.toString();
    }

    private AMIdentity getUser(Session s) throws SessionException, SSOException {
        SSOToken ssoSession = this.getSSOTokenManager().createSSOToken(s.getID().toString());
        AMIdentity user = null;
        try {
            user = IdUtils.getIdentity(ssoSession);
        }
        catch (IdRepoException e) {
            sessionDebug.error("SessionService: failed to get the user's identity object", e);
        }
        return user;
    }

    private boolean hasTopLevelAdminRole(Session s) throws SessionException, SSOException {
        SSOToken ssoSession = this.getSSOTokenManager().createSSOToken(s.getID().toString());
        return this.hasTopLevelAdminRole(ssoSession, s.getClientID());
    }

    protected boolean hasTopLevelAdminRole(String uuid) {
        boolean isTopLevelAdmin = false;
        try {
            AMIdentity topAdminRole = new AMIdentity(this.getAdminToken(), TOP_LEVEL_ADMIN_ROLE, IdType.ROLE, "/", null);
            AMIdentity user = IdUtils.getIdentity(this.getAdminToken(), uuid);
            isTopLevelAdmin = user.isMember(topAdminRole);
        }
        catch (SSOException ssoe) {
            sessionDebug.error("SessionService.hasTopLevelAdminRole:Cannot get the admin token for this operation.");
        }
        catch (IdRepoException idme) {
            sessionDebug.error("SessionService.hasTopLevelAdminRole:Cannot get the user identity or role.");
        }
        sessionDebug.error("**** New:isTopLevelAdmin = " + isTopLevelAdmin);
        return isTopLevelAdmin;
    }

    private boolean hasTopLevelAdminRole(SSOToken tokenUsedForSearch, String clientID) throws SessionException, SSOException {
        boolean topLevelAdmin = false;
        HashSet<String> actions = new HashSet<String>();
        actions.add(PERMISSION_READ);
        actions.add(PERMISSION_MODIFY);
        actions.add(PERMISSION_DELEGATE);
        try {
            DelegationPermission perm = new DelegationPermission("/", "*", "*", "*", "*", actions, Collections.EMPTY_MAP);
            DelegationEvaluator evaluator = new DelegationEvaluator();
            topLevelAdmin = evaluator.isAllowed(tokenUsedForSearch, perm, Collections.EMPTY_MAP);
        }
        catch (DelegationException de) {
            sessionDebug.error("SessionService.hasTopLevelAdminRole: failed to check the delegation permission.", de);
        }
        return topLevelAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalSession createSession(String domain) {
        block8: {
            InternalSession internalSession;
            DataInputStream in = null;
            try {
                String query = "?op=create";
                if (domain != null) {
                    query = query + "&domain=" + URLEncDec.encode(domain);
                }
                String routingCookie = null;
                URL url = new URL(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPort, deploymentURI + "/GetHttpSession" + query);
                HttpURLConnection conn = this.invokeRemote(url, null, routingCookie);
                in = new DataInputStream(conn.getInputStream());
                if (conn.getResponseCode() != 200) {
                    InternalSession internalSession2 = null;
                    SessionService.closeStream(in);
                    return internalSession2;
                }
                SessionID sid = new SessionID(in.readUTF());
                internalSession = (InternalSession)this.sessionTable.get(sid);
                SessionService.closeStream(in);
            }
            catch (Exception ex) {
                sessionDebug.error("Failed to retrieve new session", ex);
                break block8;
            }
            finally {
                SessionService.closeStream(in);
            }
            return internalSession;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean invalidateHttpSession(SessionID sid) {
        block9: {
            if (!isSessionFailoverEnabled || sid.getTail() == null) {
                return true;
            }
            DataInputStream in = null;
            URL url = null;
            try {
                String query = "?op=invalidate";
                url = new URL(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPort, deploymentURI + "/GetHttpSession" + query);
                HttpURLConnection conn = this.invokeRemote(url, sid, null);
                in = new DataInputStream(conn.getInputStream());
                boolean bl = conn.getResponseCode() == 200;
                SessionService.closeStream(in);
                return bl;
            }
            catch (ConnectException ex) {
                if (sessionDebug.messageEnabled()) {
                    sessionDebug.message("invalidateHttpSesion: failed to connect to  " + url);
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception ex2) {
                sessionDebug.error("Failed to invalidate session", ex2);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                SessionService.closeStream(in);
            }
        }
        return false;
    }

    static void closeStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                sessionDebug.error("Unable to close input", e);
            }
        }
    }

    static void closeStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                sessionDebug.error("Unable to close output", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean releaseSession(URL owner, SessionID sid) {
        block9: {
            if (sessionDebug.messageEnabled()) {
                sessionDebug.message("Attempting to release InternalSession " + sid + " from server instance: " + owner);
            }
            DataInputStream in = null;
            URL url = null;
            try {
                String query = "?op=release";
                url = new URL(owner.getProtocol(), owner.getHost(), owner.getPort(), deploymentURI + "/GetHttpSession" + query);
                HttpURLConnection conn = this.invokeRemote(url, sid, null);
                in = new DataInputStream(conn.getInputStream());
                boolean bl = conn.getResponseCode() == 200;
                SessionService.closeStream(in);
                return bl;
            }
            catch (ConnectException ex) {
                if (sessionDebug.messageEnabled()) {
                    sessionDebug.message("releaseSession: failed to connect to  " + url);
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception ex2) {
                sessionDebug.error("Failed to release session", ex2);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                SessionService.closeStream(in);
            }
        }
        return false;
    }

    int handleReleaseSession(SessionID sid) {
        if (!isSessionFailoverEnabled) {
            return 501;
        }
        Session.markNonLocal(sid);
        InternalSession is = (InternalSession)this.sessionTable.remove(sid);
        if (is != null) {
            is.cancel();
            this.removeSessionHandle(is);
            this.removeRestrictedTokens(is);
        } else if (sessionDebug.messageEnabled()) {
            sessionDebug.message("releaseSession: session not found  " + sid);
        }
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternalSession recoverSession(SessionID sid) {
        if (!isSessionFailoverEnabled) {
            return null;
        }
        if (SessionService.getUseInternalRequestRouting()) {
            InternalSession sess = null;
            try {
                sess = this.getRepository().retrieve(sid);
                this.updateSessionMaps(sess);
            }
            catch (Exception e) {
                sessionDebug.error("Failed to retrieve new session", e);
            }
            return sess;
        }
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("Recovering InternalSession from HttpSession: " + sid);
        }
        DataInputStream in = null;
        InternalSession sess = null;
        try {
            String query = "?op=recover";
            URL url = new URL(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPort, deploymentURI + "/GetHttpSession" + query);
            HttpURLConnection conn = this.invokeRemote(url, sid, null);
            in = new DataInputStream(conn.getInputStream());
            sess = (InternalSession)this.sessionTable.get(sid);
            if (sess == null) {
                sess = this.resolveRestrictedToken(sid, false);
            }
            SessionService.closeStream(in);
        }
        catch (Exception ex) {
            sessionDebug.error("Failed to retrieve new session", ex);
        }
        finally {
            SessionService.closeStream(in);
        }
        return sess;
    }

    InternalSession retrieveSession(SessionID sid, HttpSession httpSession) {
        if (isSessionFailoverEnabled && httpSession != null) {
            String sessionState = (String)httpSession.getAttribute(httpSessionPropertyName);
            if (sessionState == null) {
                sessionDebug.message("GISFHS-No InternalSession in HttpSession");
                return null;
            }
            InternalSession sess = SessionService.decrypt(sessionState);
            if (sess == null || sess.getRestrictionForToken(sid) == null && !sess.getID().equals(sid)) {
                return null;
            }
            HashSet<URL> ownerList = (HashSet<URL>)httpSession.getAttribute(httpSessionOwnerListPropertyName);
            if (ownerList == null) {
                ownerList = new HashSet<URL>();
                httpSession.setAttribute(httpSessionOwnerListPropertyName, ownerList);
            }
            Iterator iter = ownerList.iterator();
            while (iter.hasNext()) {
                URL formerOwner = (URL)iter.next();
                if (this.isLocalSessionService(formerOwner) || this.releaseSession(formerOwner, sess.getID())) continue;
                return null;
            }
            ownerList.add(this.thisSessionServiceURL);
            httpSession.setAttribute(httpSessionOwnerListPropertyName, ownerList);
            sess.setHttpSession(httpSession);
            this.updateSessionMaps(sess);
            return sess;
        }
        return null;
    }

    private void updateSessionMaps(InternalSession sess) {
        SessionID sid;
        String primaryID;
        if (sess == null) {
            return;
        }
        if (this.checkIfShouldDestroy(sess)) {
            return;
        }
        sess.putProperty(Session.lbCookieName, WebtopNaming.getLBCookieValue(this.getLocalServerID()));
        if (SessionService.getUseInternalRequestRouting() && !this.isLocalServer(primaryID = (sid = sess.getID()).getExtension("S1"))) {
            this.remoteSessionSet.add(sid);
        }
        this.sessionTable.put(sess.getID(), sess);
        String sessionHandle = sess.getSessionHandle();
        if (sessionHandle != null) {
            this.sessionHandleTable.put(sessionHandle, sess);
        }
        Object[] tokens = sess.getRestrictedTokens();
        for (int i = 0; i < tokens.length; ++i) {
            this.restrictedTokenMap.put(tokens[i], sess.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpRemoteSessions() {
        if (SessionService.getUseInternalRequestRouting()) {
            Set set = this.remoteSessionSet;
            synchronized (set) {
                Iterator iter = this.remoteSessionSet.iterator();
                while (iter.hasNext()) {
                    SessionID sid = (SessionID)iter.next();
                    String hostServer = null;
                    try {
                        hostServer = this.getCurrentHostServer(sid);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (this.isLocalServer(hostServer)) continue;
                    iter.remove();
                }
            }
        }
    }

    boolean checkIfShouldDestroy(InternalSession sess) {
        boolean shouldDestroy = false;
        try {
            shouldDestroy = sess.shouldDestroy();
        }
        catch (Exception ex) {
            sessionDebug.error("Exception in session shouldDestroy() : ", ex);
            shouldDestroy = true;
        }
        if (shouldDestroy) {
            try {
                sessionService.removeInternalSession(sess.getID());
            }
            catch (Exception ex) {
                sessionDebug.error("Exception while removing session : ", ex);
            }
        }
        return shouldDestroy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveSession(SessionID sid) {
        if (!isSessionFailoverEnabled) {
            return false;
        }
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("Saving internal session using remote method " + sid);
        }
        InputStream in = null;
        try {
            String query = "?op=save";
            URL url = new URL(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPort, deploymentURI + "/GetHttpSession" + query);
            HttpURLConnection conn = this.invokeRemote(url, sid, null);
            in = conn.getInputStream();
            boolean bl = conn.getResponseCode() == 200;
            SessionService.closeStream(in);
            return bl;
        }
        catch (Exception ex) {
            sessionDebug.error("Failed to save session", ex);
        }
        finally {
            SessionService.closeStream(in);
        }
        return false;
    }

    int handleSaveSession(SessionID sid, HttpSession httpSession) {
        if (!isSessionFailoverEnabled) {
            return 501;
        }
        InternalSession is = (InternalSession)this.sessionTable.get(sid);
        if (is == null) {
            sessionDebug.error("handleSaveSession: session not found " + sid);
            return 404;
        }
        if (!is.getID().getTail().equals(SessionService.extractHttpSessionId(httpSession))) {
            sessionDebug.error("handleSaveSession: http session id does not match sid " + sid);
            return 500;
        }
        this.doSaveSession(is, httpSession);
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRestrictedTokenIdRemotely(URL owner, SessionID masterSid, TokenRestriction restriction) {
        String string;
        DataOutputStream out;
        DataInputStream in;
        block8: {
            String string2;
            block7: {
                in = null;
                out = null;
                try {
                    String query = "?op=get_restricted_token";
                    URL url = new URL(owner.getProtocol(), owner.getHost(), owner.getPort(), deploymentURI + "/GetHttpSession" + query);
                    HttpURLConnection conn = this.invokeRemote(url, masterSid, null);
                    conn.setRequestMethod("POST");
                    conn.setDoOutput(true);
                    conn.setRequestProperty("Content-Type", "application/octet-stream");
                    ByteArrayOutputStream bs = new ByteArrayOutputStream();
                    DataOutputStream ds = new DataOutputStream(bs);
                    ds.writeUTF(TokenRestrictionFactory.marshal(restriction));
                    ds.flush();
                    ds.close();
                    byte[] marshalledRestriction = bs.toByteArray();
                    conn.setRequestProperty("Content-Length", Integer.toString(marshalledRestriction.length));
                    out = new DataOutputStream(conn.getOutputStream());
                    out.write(marshalledRestriction);
                    out.close();
                    out = null;
                    in = new DataInputStream(conn.getInputStream());
                    if (conn.getResponseCode() != 200) {
                        string2 = null;
                        SessionService.closeStream(in);
                        break block7;
                    }
                    string = in.readUTF();
                    SessionService.closeStream(in);
                    break block8;
                }
                catch (Exception ex) {
                    sessionDebug.error("Failed to create restricted token remotely", ex);
                    return null;
                }
            }
            SessionService.closeStream(out);
            return string2;
        }
        SessionService.closeStream(out);
        return string;
        finally {
            SessionService.closeStream(in);
            SessionService.closeStream(out);
        }
    }

    String handleGetRestrictedTokenIdRemotely(SessionID masterSid, TokenRestriction restriction) {
        try {
            return this.doGetRestrictedTokenId(masterSid, restriction);
        }
        catch (Exception ex) {
            sessionDebug.error("Failed to create restricted token remotely", ex);
            return null;
        }
    }

    void saveForFailover(InternalSession session) {
        if (!isSessionFailoverEnabled) {
            return;
        }
        if (SessionService.getUseInternalRequestRouting()) {
            if (!session.willExpire()) {
                return;
            }
            try {
                this.getRepository().save(session);
            }
            catch (Exception e) {
                sessionDebug.error("SessionService.saveForFailover: exception encountered", e);
            }
        } else if (useRemoteSaveMethod) {
            this.saveSession(session.getID());
        } else {
            HttpSession httpSession = session.getHttpSession();
            if (httpSession != null) {
                this.doSaveSession(session, httpSession);
            }
        }
    }

    private void doSaveSession(InternalSession session, HttpSession httpSession) {
        try {
            httpSession.setAttribute(httpSessionPropertyName, (Object)SessionService.encrypt(session));
        }
        catch (Exception e) {
            sessionDebug.error("SessionService.doSaveSession: exception encountered", e);
        }
    }

    private HttpURLConnection invokeRemote(URL url, SessionID sid, String extraCookies) throws Exception {
        if (!isSessionFailoverEnabled) {
            return null;
        }
        HttpURLConnection connection = null;
        try {
            connection = HttpURLConnectionManager.getConnection(url);
            String securityCookie = (String)AccessController.doPrivileged(new EncodeAction(this.thisSessionServerURL + "@" + System.currentTimeMillis()));
            String cookie = "DSAMESecurityCookie=" + securityCookie;
            if (extraCookies != null) {
                cookie = cookie + ";" + extraCookies;
            }
            if (sid != null) {
                cookie = cookie + ";" + Session.getCookieName() + "=" + sid;
                String httpId = sid.getTail();
                if (httpId != null) {
                    cookie = cookie + ";" + SessionService.getHttpSessionTrackingCookieName() + "=" + httpId;
                }
            }
            connection.setRequestProperty("Cookie", cookie);
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
        }
        catch (Exception ex) {
            sessionDebug.message("Failed contacting " + url, ex);
            throw ex;
        }
        return connection;
    }

    public static String encrypt(Object obj) {
        String strEncrypted;
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream objOutStream = new ObjectOutputStream(byteOut);
            objOutStream.writeObject(obj);
            String strUnEncrypted = Base64.encode(byteOut.toByteArray());
            strEncrypted = (String)AccessController.doPrivileged(new EncodeAction(strUnEncrypted, Crypt.getHardcodedKeyEncryptor()));
        }
        catch (Exception e) {
            sessionDebug.message("Error in encrypting the Internal Session object");
            return null;
        }
        return strEncrypted;
    }

    public static InternalSession decrypt(String strEncrypted) {
        if (strEncrypted == null) {
            return null;
        }
        byte[] byteDecrypted = null;
        Object tempObject = null;
        try {
            String strDecrypted = (String)AccessController.doPrivileged(new DecodeAction(strEncrypted, Crypt.getHardcodedKeyEncryptor()));
            byteDecrypted = Base64.decode(strDecrypted);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteDecrypted);
            ObjectInputStream objInStream = new ObjectInputStream(byteIn);
            tempObject = objInStream.readObject();
        }
        catch (Exception e) {
            sessionDebug.message("Error in decrypting the Internal Session object" + e.getMessage());
            return null;
        }
        if (tempObject == null) {
            return null;
        }
        return (InternalSession)tempObject;
    }

    public static String encodeID(String decodedStr) {
        int i;
        if (decodedStr == null) {
            return null;
        }
        int numberOfChar = 0;
        char[] decoded = decodedStr.toCharArray();
        for (i = 0; i < decoded.length; ++i) {
            if (decoded[i] != '%') continue;
            ++numberOfChar;
        }
        int finalLength = decoded.length + numberOfChar * 2;
        char[] encoded = new char[finalLength];
        int j = 0;
        block4: for (i = 0; i < decoded.length; ++i) {
            switch (decoded[i]) {
                case '%': {
                    encoded[j] = 37;
                    encoded[j + 1] = 50;
                    encoded[j + 2] = 53;
                    j += 3;
                    continue block4;
                }
                default: {
                    encoded[j] = decoded[i];
                    ++j;
                }
            }
        }
        return String.valueOf(encoded);
    }

    protected static void debugIS(String calledFrom, Object obj) {
        block6: {
            InternalSession is = null;
            if (obj == null) {
                sessionDebug.message("InternalSession Attribute is NULL in -->" + calledFrom);
                return;
            }
            is = (InternalSession)obj;
            if (is != null) {
                try {
                    sessionDebug.message(calledFrom + " --Value of sessionID-->" + is.getID());
                    sessionDebug.message(calledFrom + " --Value of clientDomain-->" + is.getClientDomain());
                    sessionDebug.message(calledFrom + " --Value of maxSessionTime-->" + is.getMaxSessionTime());
                    sessionDebug.message(calledFrom + " --Value of sessionState-->" + is.getState());
                    sessionDebug.message(calledFrom + " --Value of idleTime-->" + is.getIdleTime());
                    if (is.getProperty("Name") != null) {
                        sessionDebug.message(calledFrom + " --Value of property Name is -->" + is.getProperty("Name"));
                        break block6;
                    }
                    sessionDebug.message(calledFrom + "  --Value of property Name is NULL");
                }
                catch (Exception e) {
                    sessionDebug.message("ERROR in debugIS" + e.getMessage());
                }
            } else {
                sessionDebug.message("InternalSession is NULL in -->" + calledFrom);
            }
        }
    }

    public static boolean matchFilter(String string, String pattern) {
        if (pattern.equals("*") || pattern.equals(string)) {
            return true;
        }
        int length = pattern.length();
        int wildCardIndex = pattern.indexOf("*");
        if (wildCardIndex >= 0) {
            String patternSubStr = pattern.substring(0, wildCardIndex);
            if (!string.startsWith(patternSubStr, 0)) {
                return false;
            }
            int beginIndex = patternSubStr.length() + 1;
            int stringIndex = 0;
            if (wildCardIndex > 0) {
                stringIndex = beginIndex;
            }
            String sub = pattern.substring(beginIndex, length);
            while ((wildCardIndex = pattern.indexOf("*", beginIndex)) != -1) {
                patternSubStr = pattern.substring(beginIndex, wildCardIndex);
                if (string.indexOf(patternSubStr, stringIndex) == -1) {
                    return false;
                }
                beginIndex = wildCardIndex + 1;
                stringIndex = stringIndex + patternSubStr.length() + 1;
                sub = pattern.substring(beginIndex, length);
            }
            if (string.endsWith(sub)) {
                return true;
            }
        }
        return false;
    }

    public static int getConnectionMaxWaitTime() {
        return connectionMaxWaitTime;
    }

    public static int getMaxWaitTimeForConstraint() {
        return maxWaitTimeForConstraint;
    }

    public static String getJdbcDriverClass() {
        return jdbcDriverClass;
    }

    public static String getJdbcURL() {
        return jdbcURL;
    }

    public static int getMaxPoolSize() {
        return maxPoolSize;
    }

    public static int getMinPoolSize() {
        return minPoolSize;
    }

    public static String getSessionStoreUserName() {
        return sessionStoreUserName;
    }

    public static String getSessionStorePassword() {
        return sessionStorePassword;
    }

    public boolean isSiteEnabled() {
        return isSiteEnabled;
    }

    public static boolean isPropertyNotificationEnabled() {
        return isPropertyNotificationEnabled;
    }

    protected static void setPropertyNotificationEnabled(boolean value) {
        isPropertyNotificationEnabled = value;
    }

    public static boolean isSendPropertyNotification(String key) {
        if (!isPropertyNotificationEnabled) {
            return false;
        }
        return notificationProperties.contains(key);
    }

    protected static Set getNotificationProperties() {
        return notificationProperties;
    }

    protected static void setNotificationProperties(Set prop) {
        notificationProperties = prop;
    }

    static /* synthetic */ ThreadPool access$000() {
        return threadPool;
    }

    static /* synthetic */ Vector access$100(SessionService x0) {
        return x0.sessionEventURLs;
    }

    static /* synthetic */ SessionInfo access$200(SessionService x0, InternalSession x1, SessionID x2) throws SessionException {
        return x0.makeSessionInfo(x1, x2);
    }

    static {
        String status;
        String thres;
        LOG_PROVIDER = "Session";
        threadPool = null;
        ssoManager = null;
        sessionDebug = null;
        maxSessions = 10000;
        numberOfActiveSessions = 0;
        dsameAdminDN = null;
        dsameAdminPassword = null;
        logStatus = false;
        logger = null;
        errorLogger = null;
        logProvider = null;
        httpSessionTrackingCookieName = SystemProperties.get("com.iplanet.am.session.failover.httpSessionTrackingCookieName", "JSESSIONID");
        sunAppServerLBRoutingCookieName = SystemProperties.get("com.iplanet.am.session.failover.sunAppServerLBRoutingCookieName", "JROUTE");
        defaultApplicationMaxCachingTime = String.valueOf(0x222222222222222L);
        applicationMaxCachingTime = Long.valueOf(SystemProperties.get("com.sun.identity.session.application.maxCacheTime", defaultApplicationMaxCachingTime));
        sessionStoreUserName = null;
        sessionStorePassword = null;
        clusterMemberMap = new HashMap();
        connectionMaxWaitTime = 5000;
        jdbcDriverClass = null;
        jdbcURL = null;
        minPoolSize = 8;
        maxPoolSize = 32;
        maxWaitTimeForConstraint = 6000;
        isPropertyNotificationEnabled = false;
        adminToken = null;
        sessionDebug = Debug.getInstance("amSession");
        stats = Stats.getInstance("amMasterSessionTableStats");
        int poolSize = 10;
        int threshold = 100;
        String size = SystemProperties.get("com.iplanet.am.notification.threadpool.size");
        if (size != null) {
            try {
                poolSize = Integer.parseInt(size);
            }
            catch (NumberFormatException e) {
                sessionDebug.error("SessionService.<init>: incorrect thread pool size" + size + "defaulting to " + 10);
            }
        }
        if ((thres = SystemProperties.get("com.iplanet.am.notification.threadpool.threshold")) != null) {
            try {
                threshold = Integer.parseInt(thres);
            }
            catch (Exception e) {
                sessionDebug.error("SessionService.<init>: incorrect thread threshold" + thres + "defaulting to " + 100);
            }
        }
        threadPool = new ThreadPool("amSession", poolSize, threshold, true, sessionDebug);
        ShutdownManager.getInstance().addShutdownListener((ShutdownListener)new /* Unavailable Anonymous Inner Class!! */);
        if (threadPool != null) {
            try {
                maxSessions = Integer.parseInt(SystemProperties.get("com.iplanet.am.session.maxSessions"));
            }
            catch (Exception ex) {
                maxSessions = 10000;
            }
        }
        if ((status = SystemProperties.get("com.iplanet.am.logstatus")) == null) {
            status = "INACTIVE";
        }
        logStatus = status.equalsIgnoreCase("ACTIVE");
        returnAppSession = Boolean.valueOf(SystemProperties.get("com.sun.identity.session.returnAppSession", "false"));
        sessionService = null;
        deploymentURI = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
        isSessionFailoverEnabled = false;
        isSiteEnabled = false;
        isSessionConstraintEnabled = false;
        denyLoginIfDBIsDown = false;
        bypassConstratintForToplevelAdmin = false;
        constraintResultingBehavior = 1;
        useRemoteSaveMethod = Boolean.valueOf(SystemProperties.get("com.iplanet.am.session.failover.useRemoteSaveMethod"));
        useInternalRequestRouting = Boolean.valueOf(SystemProperties.get("com.iplanet.am.session.failover.useInternalRequestRouting", "true"));
        sessionRepository = null;
        initialized = false;
    }
}

