/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMDirectoryAccessFactory;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.common.IDCTreeServices;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class AMDCTree
implements AMConstants {
    protected static ServiceSchema gsc = null;
    public static final String IPLANET_DOMAIN_NAME_ATTR = "sunPreferredDomain";
    public static final String INET_CANONICAL_DOMAIN = "inetcanonicaldomainname";
    public static final String DOMAIN_BASE_DN = "inetDomainBaseDN";
    private static Map domainMap;
    private static Map canonicalDomainMap;
    private static Debug debug;
    private static IDCTreeServices dcTreeServices;

    AMDCTree() {
    }

    protected static boolean isRequired() throws AMException {
        try {
            if (AMCompliance.gsc == null) {
                ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAdminConsoleService", (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
                AMCompliance.gsc = scm.getGlobalSchema();
            }
            Map attrMap = AMCompliance.gsc.getAttributeDefaults();
            Set values = (Set)attrMap.get("iplanet-am-admin-console-dctree");
            boolean required = false;
            if (values == null || values.isEmpty()) {
                required = false;
            } else {
                String val = (String)values.iterator().next();
                required = val.equalsIgnoreCase("true");
            }
            return required;
        }
        catch (SMSException ex) {
            debug.error(AMSDKBundle.getString("354"), ex);
            throw new AMException(AMSDKBundle.getString("354"), "354");
        }
        catch (SSOException ex) {
            debug.error(AMSDKBundle.getString("345"), ex);
            throw new AMException(AMSDKBundle.getString("354"), "354");
        }
    }

    protected static String getOrganizationDN(SSOToken token, String domainName) throws AMException {
        return dcTreeServices.getOrganizationDN(token, domainName);
    }

    protected static AttrSet[] splitAttrSet(String orgDN, AttrSet attrSet) throws AMException {
        AttrSet[] attrArray = new AttrSet[]{new AttrSet(), new AttrSet()};
        if (attrSet == null) {
            return attrArray;
        }
        Set dcNodeAttrs = AMDCTree.dcNodeAttributes();
        Iterator it = dcNodeAttrs.iterator();
        while (it.hasNext()) {
            Attr attr;
            String aName = (String)it.next();
            if (aName.indexOf("objectclass=") > -1) {
                attr = attrSet.getAttribute("objectclass");
                String oc = aName.substring("objectclass=".length());
                Attr dcAttr = new Attr("objectclass");
                if (attr == null || !attr.contains(oc)) continue;
                attr.removeValue(oc);
                dcAttr.addValue(oc);
                attrSet.replace(attr);
                attrArray[1].add(dcAttr);
                continue;
            }
            attr = attrSet.getAttribute(aName);
            if (attr == null) continue;
            attrArray[1].add(attr);
            attrSet.remove(aName);
        }
        attrArray[0] = attrSet;
        if (debug.messageEnabled()) {
            debug.message("AMCompliance.splitAttrSet: domain attrset = " + attrArray[1].toString());
            debug.message("AMCompliance.splitAttrSet: non-domain attrset = " + attrArray[0].toString());
        }
        return attrArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cleanDomainMap(String canonOrgDN) {
        Map map = canonicalDomainMap;
        synchronized (map) {
            canonicalDomainMap.remove(canonOrgDN);
        }
        map = domainMap;
        synchronized (map) {
            domainMap.remove(canonOrgDN);
        }
    }

    private static Set dcNodeAttributes() throws AMException {
        try {
            Map attrMap;
            Set values;
            if (gsc == null) {
                ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAdminConsoleService", (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
                gsc = scm.getGlobalSchema();
            }
            if ((values = (Set)(attrMap = gsc.getAttributeDefaults()).get("iplanet-am-admin-console-dctree-attr-list")) == null) {
                if (debug.messageEnabled()) {
                    debug.message("DCTree.dcNodeAttributes = null");
                }
                return Collections.EMPTY_SET;
            }
            if (debug.messageEnabled()) {
                debug.message("DCTree.dcNodeAttributes = " + values.toString());
            }
            return values;
        }
        catch (SMSException ex) {
            debug.error(AMSDKBundle.getString("908"), ex);
            throw new AMException(AMSDKBundle.getString("908"), "908");
        }
        catch (SSOException ex) {
            debug.error(AMSDKBundle.getString("902"), ex);
            throw new AMException(AMSDKBundle.getString("902"), "902");
        }
    }

    static {
        debug = AMCommonUtils.debug;
        dcTreeServices = AMDirectoryAccessFactory.getDCTreeServices();
        domainMap = new HashMap();
        canonicalDomainMap = new HashMap();
    }
}

