/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jbpm.identity.Entity;
import org.jbpm.identity.Membership;
import org.jbpm.identity.User;

public class Group
extends Entity {
    private static final long serialVersionUID = 1L;
    protected String type = null;
    protected Group parent = null;
    protected Set children = null;
    protected Set memberships = null;

    public Group() {
    }

    public Group(String name) {
        super(name);
    }

    public Group(String name, String type) {
        super(name);
        this.type = type;
    }

    public void addMembership(Membership membership) {
        if (this.memberships == null) {
            this.memberships = new HashSet();
        }
        this.memberships.add(membership);
        membership.setGroup(this);
    }

    public void addChild(Group child) {
        if (this.children == null) {
            this.children = new HashSet();
        }
        this.children.add(child);
        child.setParent(this);
    }

    public Set getUsers() {
        HashSet<User> users = new HashSet<User>();
        if (this.memberships != null) {
            Iterator iter = this.memberships.iterator();
            while (iter.hasNext()) {
                Membership membership = (Membership)iter.next();
                users.add(membership.getUser());
            }
        }
        return users;
    }

    public Set getUsersForMembershipRole(String membershipRole) {
        HashSet<User> users = new HashSet<User>();
        if (this.memberships != null) {
            Iterator iter = this.memberships.iterator();
            while (iter.hasNext()) {
                Membership membership = (Membership)iter.next();
                if (!membershipRole.equals(membership.getRole())) continue;
                users.add(membership.getUser());
            }
        }
        return users;
    }

    public long getId() {
        return this.id;
    }

    public Set getMemberships() {
        return this.memberships;
    }

    public Set getChildren() {
        return this.children;
    }

    public Group getParent() {
        return this.parent;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setChildren(Set children) {
        this.children = children;
    }

    public void setMemberships(Set memberships) {
        this.memberships = memberships;
    }

    public void setParent(Group parent) {
        this.parent = parent;
    }
}

