/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.client.STSIssuedTokenConfiguration;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.trust.WSTrustClientContract;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponseCollection;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.ws.security.wsu10.AttributedDateTime;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSTrustClientContractImpl
implements WSTrustClientContract {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    private static final SimpleDateFormat calendarFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'", Locale.getDefault());

    public void handleRSTR(BaseSTSRequest request, BaseSTSResponse response, IssuedTokenContext context) throws WSTrustException {
        WSTrustVersion wstVer = WSTrustVersion.getInstance(((STSIssuedTokenConfiguration)context.getSecurityPolicy().get(0)).getProtocol());
        RequestSecurityToken rst = (RequestSecurityToken)request;
        RequestSecurityTokenResponse rstr = null;
        if (response instanceof RequestSecurityTokenResponse) {
            rstr = (RequestSecurityTokenResponse)response;
        } else if (response instanceof RequestSecurityTokenResponseCollection) {
            rstr = ((RequestSecurityTokenResponseCollection)response).getRequestSecurityTokenResponses().get(0);
        }
        if (rst.getRequestType().toString().equals(wstVer.getIssueRequestTypeURI())) {
            String appliesTo = null;
            AppliesTo requestAppliesTo = rst.getAppliesTo();
            if (requestAppliesTo != null) {
                appliesTo = WSTrustUtil.getAppliesToURI(requestAppliesTo);
            }
            RequestedSecurityToken securityToken = rstr.getRequestedSecurityToken();
            RequestedAttachedReference attachedRef = rstr.getRequestedAttachedReference();
            RequestedUnattachedReference unattachedRef = rstr.getRequestedUnattachedReference();
            RequestedProofToken proofToken = rstr.getRequestedProofToken();
            byte[] key = this.getKey(wstVer, rstr, proofToken, rst, appliesTo);
            if (key != null) {
                context.setProofKey(key);
            }
            this.setLifetime(rstr, context);
            if (securityToken == null && proofToken == null) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0018_TOKENS_NULL(appliesTo));
                throw new WSTrustException(LogStringsMessages.WST_0018_TOKENS_NULL(appliesTo));
            }
            if (securityToken != null) {
                context.setSecurityToken(securityToken.getToken());
            }
            if (attachedRef != null) {
                context.setAttachedSecurityTokenReference(attachedRef.getSTR());
            }
            if (unattachedRef != null) {
                context.setUnAttachedSecurityTokenReference(unattachedRef.getSTR());
            }
        }
    }

    public BaseSTSResponse handleRSTRForNegotiatedExchange(BaseSTSRequest request, BaseSTSResponse response, IssuedTokenContext context) throws WSTrustException {
        throw new UnsupportedOperationException("Unsupported operation: handleRSTRForNegotiatedExchange");
    }

    public BaseSTSResponse createRSTRForClientInitiatedIssuedTokenContext(AppliesTo scopes, IssuedTokenContext context) throws WSTrustException {
        throw new UnsupportedOperationException("Unsupported operation: createRSTRForClientInitiatedIssuedTokenContext");
    }

    public boolean containsChallenge(RequestSecurityTokenResponse rstr) {
        throw new UnsupportedOperationException("Unsupported operation: containsChallenge");
    }

    public URI getComputedKeyAlgorithmFromProofToken(RequestSecurityTokenResponse rstr) {
        throw new UnsupportedOperationException("Unsupported operation: getComputedKeyAlgorithmFromProofToken");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLifetime(RequestSecurityTokenResponse rstr, IssuedTokenContext context) throws WSTrustException {
        block5: {
            try {
                Lifetime lifetime = rstr.getLifetime();
                if (lifetime == null) break block5;
                AttributedDateTime created = lifetime.getCreated();
                AttributedDateTime expires = lifetime.getExpires();
                SimpleDateFormat simpleDateFormat = calendarFormatter;
                synchronized (simpleDateFormat) {
                    Date dateCreated = calendarFormatter.parse(created.getValue());
                    Date dateExpires = calendarFormatter.parse(expires.getValue());
                    context.setCreationTime(dateCreated);
                    context.setExpirationTime(dateExpires);
                }
            }
            catch (ParseException ex) {
                throw new WSTrustException(ex.getMessage(), ex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] getKey(WSTrustVersion wstVer, RequestSecurityTokenResponse rstr, RequestedProofToken proofToken, RequestSecurityToken rst, String appliesTo) throws WSTrustException {
        byte[] key = null;
        if (proofToken != null) {
            String proofTokenType = proofToken.getProofTokenType();
            if ("ComputedKey".equals(proofTokenType)) {
                return this.computeKey(wstVer, rstr, proofToken, rst);
            }
            if ("SecurityTokenReference".equals(proofTokenType)) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0001_UNSUPPORTED_PROOF_TOKEN_TYPE(proofTokenType, appliesTo));
                throw new WSTrustException(LogStringsMessages.WST_0001_UNSUPPORTED_PROOF_TOKEN_TYPE(proofTokenType, appliesTo));
            }
            if ("EncryptedKey".equals(proofTokenType)) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0001_UNSUPPORTED_PROOF_TOKEN_TYPE(proofTokenType, appliesTo));
                throw new WSTrustException(LogStringsMessages.WST_0001_UNSUPPORTED_PROOF_TOKEN_TYPE(proofTokenType, appliesTo));
            }
            if ("BinarySecret".equals(proofTokenType)) {
                BinarySecret binarySecret = proofToken.getBinarySecret();
                return binarySecret.getRawValue();
            }
            log.log(Level.SEVERE, LogStringsMessages.WST_0019_INVALID_PROOF_TOKEN_TYPE(proofTokenType, appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0019_INVALID_PROOF_TOKEN_TYPE(proofTokenType, appliesTo));
        }
        Entropy clientEntropy = rst.getEntropy();
        if (clientEntropy == null) return key;
        BinarySecret bs = clientEntropy.getBinarySecret();
        if (bs == null) return key;
        return bs.getRawValue();
    }

    private byte[] computeKey(WSTrustVersion wstVer, RequestSecurityTokenResponse rstr, RequestedProofToken proofToken, RequestSecurityToken rst) throws WSTrustException, UnsupportedOperationException {
        int keySize;
        URI computedKey = proofToken.getComputedKey();
        Entropy clientEntropy = rst.getEntropy();
        Entropy serverEntropy = rstr.getEntropy();
        BinarySecret clientBinarySecret = clientEntropy.getBinarySecret();
        BinarySecret serverBinarySecret = serverEntropy.getBinarySecret();
        byte[] clientEntropyBytes = null;
        byte[] serverEntropyBytes = null;
        if (clientBinarySecret != null) {
            clientEntropyBytes = clientBinarySecret.getRawValue();
        }
        if (serverBinarySecret != null) {
            serverEntropyBytes = serverBinarySecret.getRawValue();
        }
        if ((keySize = (int)rstr.getKeySize() / 8) == 0) {
            keySize = (int)rst.getKeySize() / 8;
        }
        byte[] key = null;
        if (computedKey.toString().equals(wstVer.getCKPSHA1algorithmURI())) {
            try {
                key = SecurityUtil.P_SHA1(clientEntropyBytes, serverEntropyBytes, keySize);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0037_ERROR_COMPUTING_KEY(), ex);
                throw new WSTrustException(LogStringsMessages.WST_0037_ERROR_COMPUTING_KEY(), ex);
            }
        } else {
            log.log(Level.SEVERE, LogStringsMessages.WST_0026_INVALID_CK_ALGORITHM(computedKey));
            throw new WSTrustException(LogStringsMessages.WST_0026_INVALID_CK_ALGORITHM_E(computedKey));
        }
        return key;
    }
}

