/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyHolder {
    private MessagePolicy mp = null;
    private List<PolicyAssertion> scList = null;
    private List<PolicyAssertion> issuedTokenList = null;
    private List<PolicyAssertion> kerberosTokenList = null;
    private static final List<PolicyAssertion> EMPTY_LIST = Collections.emptyList();
    private AlgorithmSuite suite = null;
    private HashMap<WSDLFault, SecurityPolicyHolder> faultFPMap = null;
    private HashMap<String, Set<PolicyAssertion>> configAssertions;
    private boolean isIssuedTokenAsSignedSupportingToken = false;

    public void setMessagePolicy(MessagePolicy mp) {
        this.mp = mp;
    }

    public MessagePolicy getMessagePolicy() {
        return this.mp;
    }

    public void addSecureConversationToken(PolicyAssertion pa) {
        if (this.scList == null) {
            this.scList = new ArrayList<PolicyAssertion>();
        }
        this.scList.add(pa);
    }

    public List<PolicyAssertion> getSecureConversationTokens() {
        return this.scList == null ? EMPTY_LIST : this.scList;
    }

    public void addKerberosToken(PolicyAssertion pa) {
        if (this.kerberosTokenList == null) {
            this.kerberosTokenList = new ArrayList<PolicyAssertion>();
        }
        this.kerberosTokenList.add(pa);
    }

    public List<PolicyAssertion> getKerberosTokens() {
        return this.kerberosTokenList == null ? EMPTY_LIST : this.kerberosTokenList;
    }

    public void addIssuedToken(PolicyAssertion pa) {
        if (this.issuedTokenList == null) {
            this.issuedTokenList = new ArrayList<PolicyAssertion>();
        }
        this.issuedTokenList.add(pa);
    }

    public void addIssuedTokens(List<PolicyAssertion> list) {
        if (this.issuedTokenList == null) {
            this.issuedTokenList = list;
        } else {
            this.issuedTokenList.addAll(list);
        }
    }

    public List<PolicyAssertion> getIssuedTokens() {
        return this.issuedTokenList == null ? EMPTY_LIST : this.issuedTokenList;
    }

    public AlgorithmSuite getBindingLevelAlgSuite() {
        return this.suite;
    }

    public void setBindingLevelAlgSuite(AlgorithmSuite suite) {
        this.suite = suite;
    }

    public boolean isIssuedTokenAsSignedSupportingToken() {
        return this.isIssuedTokenAsSignedSupportingToken;
    }

    public void isIssuedTokenAsSignedSupportingToken(boolean isIssuedTokenAsSignedSupportingToken) {
        this.isIssuedTokenAsSignedSupportingToken = isIssuedTokenAsSignedSupportingToken;
    }

    public void addFaultPolicy(WSDLFault fault, SecurityPolicyHolder policy) {
        if (this.faultFPMap == null) {
            this.faultFPMap = new HashMap();
        }
        this.faultFPMap.put(fault, policy);
    }

    public SecurityPolicyHolder getFaultPolicy(WSDLFault fault) {
        if (this.faultFPMap == null) {
            return null;
        }
        return this.faultFPMap.get(fault);
    }

    public void addConfigAssertions(PolicyAssertion assertion) {
        Set<PolicyAssertion> assertions;
        if (this.configAssertions == null) {
            this.configAssertions = new HashMap();
        }
        if ((assertions = this.configAssertions.get(assertion.getName().getNamespaceURI())) == null) {
            assertions = new HashSet<PolicyAssertion>();
            this.configAssertions.put(assertion.getName().getNamespaceURI(), assertions);
        }
        assertions.add(assertion);
    }

    public Set getConfigAssertions(String namespaceuri) {
        if (this.configAssertions == null) {
            return null;
        }
        return this.configAssertions.get(namespaceuri);
    }
}

