/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.sequence;

import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rm.runtime.sequence.SequenceData;
import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemorySequenceData
implements SequenceData {
    private final String sequenceId;
    private final long expirationTime;
    private Sequence.Status status;
    private boolean ackRequestedFlag;
    private long lastMessageId;
    private final Collection<Long> unackedMessageIdentifiersStorage;
    private final ReadWriteLock messageIdLock = new ReentrantReadWriteLock();

    public InMemorySequenceData(Collection<Long> unackedMessageIdentifiersStorage, String sequenceId, long expirationTime, long lastMessageId, Sequence.Status status, boolean ackRequestedFlag) {
        this.unackedMessageIdentifiersStorage = unackedMessageIdentifiersStorage;
        this.sequenceId = sequenceId;
        this.expirationTime = expirationTime;
        this.lastMessageId = lastMessageId;
        this.status = status;
        this.ackRequestedFlag = ackRequestedFlag;
    }

    @Override
    public boolean isAckRequestedFlag() {
        return this.ackRequestedFlag;
    }

    @Override
    public void setAckRequestedFlag(boolean ackRequestedFlag) {
        this.ackRequestedFlag = ackRequestedFlag;
    }

    @Override
    public Sequence.Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Sequence.Status status) {
        this.status = status;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public String getSequenceId() {
        return this.sequenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastMessageId() {
        try {
            this.messageIdLock.readLock().lock();
            long l = this.lastMessageId;
            return l;
        }
        finally {
            this.messageIdLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long updateLastMessageId(long newId) {
        try {
            this.messageIdLock.writeLock().lock();
            long oldValue = this.lastMessageId;
            this.lastMessageId = newId;
            long l = oldValue;
            return l;
        }
        finally {
            this.messageIdLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long incrementAndGetLastMessageId() {
        try {
            this.messageIdLock.writeLock().lock();
            ++this.lastMessageId;
            long l = this.lastMessageId;
            return l;
        }
        finally {
            this.messageIdLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Long> getAllUnackedIndexes() {
        try {
            this.messageIdLock.readLock().lock();
            Collection<Long> collection = this.unackedMessageIdentifiersStorage;
            return collection;
        }
        finally {
            this.messageIdLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noUnackedMessageIds() {
        try {
            this.messageIdLock.readLock().lock();
            boolean bl = this.unackedMessageIdentifiersStorage.isEmpty();
            return bl;
        }
        finally {
            this.messageIdLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUnackedMessageId(long messageId) {
        try {
            this.messageIdLock.writeLock().lock();
            this.unackedMessageIdentifiersStorage.add(messageId);
        }
        finally {
            this.messageIdLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUnackedMessageId(long messageId) {
        try {
            this.messageIdLock.writeLock().lock();
            boolean bl = this.unackedMessageIdentifiersStorage.remove(messageId);
            return bl;
        }
        finally {
            this.messageIdLock.writeLock().unlock();
        }
    }

    @Override
    public void acquireMessageIdDataReadOnlyLock() {
        this.messageIdLock.readLock().lock();
    }

    @Override
    public void releaseMessageIdDataReadOnlyLock() {
        this.messageIdLock.readLock().unlock();
    }

    @Override
    public void acquireMessageIdDataReadWriteLock() {
        this.messageIdLock.writeLock().lock();
    }

    @Override
    public void releaseMessageIdDataReadWriteLock() {
        this.messageIdLock.writeLock().unlock();
    }
}

