/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.policy;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.RmWsException;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.policy.ConfigurationManager;
import com.sun.xml.ws.rm.policy.assertion.Rm10Assertion;
import com.sun.xml.ws.rm.policy.assertion.Rm11Assertion;
import com.sun.xml.ws.rm.policy.assertion.RmFlowControlAssertion;

public class Rm11ServiceConfiguration
implements Configuration {
    private static final RmLogger LOGGER = RmLogger.getLogger(Rm11ServiceConfiguration.class);
    private SOAPVersion soapVersion;
    private AddressingVersion addressingVersion;
    private final long inactivityTimeout;
    private final long bufferQuota;
    private final boolean orderedDelivery;
    private final Configuration.DeliveryAssurance deliveryAssurance;
    private final Configuration.SecurityBinding securityBinding;
    private final long acknowledgementInterval;
    private final boolean requestResponseDetected;

    public Rm11ServiceConfiguration(AssertionSet alternative, SOAPVersion soapVersion, AddressingVersion addressingVersion, boolean requestResponseDetected) throws RmWsException {
        this.soapVersion = soapVersion;
        this.addressingVersion = addressingVersion;
        this.requestResponseDetected = requestResponseDetected;
        if (alternative.contains(Rm10Assertion.NAME)) {
            throw LOGGER.logSevereException(new RmWsException(LocalizationMessages.WSRM_1002_MULTIPLE_WSRM_VERSIONS_IN_POLICY()));
        }
        Rm11Assertion rmAssertion = ConfigurationManager.extractAssertion(alternative, Rm11Assertion.NAME, Rm11Assertion.class);
        this.deliveryAssurance = rmAssertion.getDeliveryAssurance();
        this.orderedDelivery = rmAssertion.isOrderedDelivery();
        this.securityBinding = rmAssertion.getSecurityBinding();
        RmFlowControlAssertion rmFlowControlAssertion = ConfigurationManager.extractAssertion(alternative, RmFlowControlAssertion.NAME, RmFlowControlAssertion.class);
        this.bufferQuota = rmFlowControlAssertion != null ? rmFlowControlAssertion.getMaximumBufferSize() : -1L;
        this.inactivityTimeout = 600000L;
        this.acknowledgementInterval = -1L;
    }

    public RmVersion getRmVersion() {
        return RmVersion.WSRM11;
    }

    public SOAPVersion getSoapVersion() {
        return this.soapVersion;
    }

    public AddressingVersion getAddressingVersion() {
        return this.addressingVersion;
    }

    public boolean requestResponseOperationsDetected() {
        return this.requestResponseDetected;
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public long getSequenceAcknowledgementInterval() {
        return this.acknowledgementInterval;
    }

    public Configuration.SecurityBinding getSecurityBinding() {
        return this.securityBinding;
    }

    public Configuration.DeliveryAssurance getDeliveryAssurance() {
        return this.deliveryAssurance;
    }

    public boolean isOrderedDelivery() {
        return this.orderedDelivery;
    }

    public long getDestinationBufferQuota() {
        return this.bufferQuota;
    }

    public long getMessageRetransmissionInterval() {
        throw new UnsupportedOperationException("Not supported on the service side.");
    }

    public boolean useExponetialBackoffRetransmission() {
        throw new UnsupportedOperationException("Not supported on the service side.");
    }

    public long getAcknowledgementRequestInterval() {
        throw new UnsupportedOperationException("Not supported on the service side.");
    }

    public long getCloseSequenceOperationTimeout() {
        throw new UnsupportedOperationException("Not supported on the service side.");
    }
}

