/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.jaxws;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.sun.xml.jaxws.JAXWSMessage;
import com.sun.xml.messaging.saaj.soap.ExpressMessage;
import com.sun.xml.ws.spi.runtime.InternalSoapEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExpressSOAPXMLEncoder {
    private static final String TAG_ENVELOPE = "Envelope";
    private static final String TAG_HEADER = "Header";
    private static final String TAG_BODY = "Body";
    private static final String TAG_FAULT = "Fault";
    private XMLSerializer _xmlSerializer;
    private XMLOutputFactory staxOF = null;

    public ExpressSOAPXMLEncoder() {
        OutputFormat format = new OutputFormat();
        format.setOmitXMLDeclaration(true);
        this._xmlSerializer = new XMLSerializer(format);
        this.staxOF = XMLOutputFactory.newInstance();
    }

    public ExpressSOAPXMLEncoder(XMLOutputFactory of) {
        OutputFormat format = new OutputFormat();
        format.setOmitXMLDeclaration(true);
        this._xmlSerializer = new XMLSerializer(format);
        this.staxOF = of;
    }

    public void writeSOAPMessage(OutputStream baos, JAXWSMessage message) throws XMLStreamException, SOAPException, IOException {
        XMLStreamWriter writer = null;
        boolean _FI = false;
        writer = this.staxOF.createXMLStreamWriter(baos);
        writer.writeStartDocument();
        SOAPEnvelope env = message.getSoapMessage().getSOAPPart().getEnvelope();
        writer.writeStartElement(env.getPrefix(), TAG_ENVELOPE, env.getNamespaceURI());
        writer.writeNamespace(env.getPrefix(), env.getNamespaceURI());
        writer.writeCharacters("");
        writer.writeStartElement(env.getPrefix(), TAG_HEADER, env.getPrefix());
        writer.writeCharacters("");
        writer.flush();
        Iterator hList = ((ExpressMessage)((Object)message.getSoapMessage())).getEMHeader().getChildElements();
        while (hList.hasNext()) {
            Node node = (Node)hList.next();
            if (node.getNodeType() != 1) continue;
            this._xmlSerializer.serialize((Element)node);
        }
        writer.flush();
        if (!message.isHeaderUsed()) {
            this.writeJAXWSHeaders(message, writer);
            writer.flush();
        }
        writer.writeEndElement();
        writer.flush();
        if (!message.isBodyUsed()) {
            writer.writeStartElement(env.getPrefix(), TAG_BODY, env.getNamespaceURI());
            writer.writeCharacters("");
            this.writeJAXWSBody(message, writer, baos);
        } else {
            SOAPBody body = env.getBody();
            if (body.getNodeType() == 1) {
                this._xmlSerializer.serialize(body);
            }
        }
        writer.flush();
        writer.writeEndDocument();
        writer.flush();
    }

    public void writeJAXWSHeaders(JAXWSMessage message, XMLStreamWriter writer) {
        InternalSoapEncoder encoder = message.getEncoder();
        Object messageInfo = message.getMessageInfo();
        List headers = message.getHeaders();
        for (int i = 0; i < headers.size(); ++i) {
            Object internalHeader = headers.get(i);
        }
    }

    public void writeJAXWSBody(JAXWSMessage message, XMLStreamWriter writer, OutputStream stream) throws IOException {
        InternalSoapEncoder encoder = message.getEncoder();
        Object messageInfo = message.getMessageInfo();
        byte[] cb = message.getCanonicalizedBody();
        if (cb != null) {
            stream.write(cb);
        } else {
            Object body = message.getBody();
        }
    }

    public void constructSOAPBody(JAXWSMessage message, Node body) throws XMLStreamException, IOException {
        XMLStreamWriter writer = this.staxOF.createXMLStreamWriter(new DOMResult(body));
        this.writeJAXWSBody(message, writer, null);
    }

    public void constructSOAPHeaders(JAXWSMessage message, Node header) throws XMLStreamException {
        XMLStreamWriter writer = this.staxOF.createXMLStreamWriter(new DOMResult(header));
        this.writeJAXWSHeaders(message, writer);
    }

    class DataFilter
    implements StreamFilter {
        JAXWSMessage jxMessage = null;
        XMLStreamWriter streamWriter = null;

        DataFilter(JAXWSMessage message, XMLStreamWriter writer) {
            this.jxMessage = message;
            this.streamWriter = writer;
        }

        public boolean accept(XMLStreamReader reader) {
            if (reader.isEndElement()) {
                String localName = reader.getLocalName();
                String uri = reader.getNamespaceURI();
                if (ExpressSOAPXMLEncoder.TAG_HEADER.equals(localName) && uri.equals("http://schemas.xmlsoap.org/soap/envelope/") || uri.equals("http://www.w3.org/2003/05/soap-envelope")) {
                    if (!this.jxMessage.isHeaderUsed()) {
                        ExpressSOAPXMLEncoder.this.writeJAXWSHeaders(this.jxMessage, this.streamWriter);
                    }
                } else if ((ExpressSOAPXMLEncoder.TAG_BODY.equals(localName) && uri.equals("http://schemas.xmlsoap.org/soap/envelope/") || uri.equals("http://www.w3.org/2003/05/soap-envelope")) && !this.jxMessage.isBodyUsed()) {
                    try {
                        ExpressSOAPXMLEncoder.this.writeJAXWSBody(this.jxMessage, this.streamWriter, null);
                        this.streamWriter.flush();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            return true;
        }
    }
}

