/*
 * Decompiled with CFR 0.152.
 */
package it.javalinux.wise.core.utils;

import it.javalinux.wise.core.exceptions.WiseException;
import java.io.InputStream;
import java.util.Properties;

public class WiseProperties
extends Properties {
    public WiseProperties(String propertiesResource) throws WiseException {
        InputStream config = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesResource);
        try {
            this.load(config);
        }
        catch (Exception e) {
            throw new WiseException("Error reading '" + propertiesResource + "'.", e);
        }
        finally {
            try {
                config.close();
            }
            catch (Exception e) {}
        }
        if (this.get("wise.tmpDir") == null) {
            throw new WiseException("wise.tmpDir undefined. Please check your wise-core.properties");
        }
    }

    private WiseProperties() {
    }

    public static WiseProperties newInstance(String tmpDir) {
        WiseProperties me = new WiseProperties();
        me.setProperty("wise.tmpDir", tmpDir);
        return me;
    }
}

