/*
 * Decompiled with CFR 0.152.
 */
package it.javalinux.wise.core.utils;

import it.javalinux.wise.core.utils.JavaUtils;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    public static List<Field> getAllFields(Class cl) {
        LinkedList<Field> list = new LinkedList<Field>();
        for (Field field : cl.getDeclaredFields()) {
            if ("serialVersionUID".equals(field.getName())) continue;
            list.add(field);
        }
        if (cl.getSuperclass() != null && !cl.getSuperclass().isAssignableFrom(Throwable.class)) {
            list.addAll(ReflectionUtils.getAllFields(cl.getSuperclass()));
        }
        return list;
    }

    public static String setterMethodName(String fieldName, boolean isBoolean) {
        String setter = "set" + JavaUtils.capitalize(fieldName);
        if (isBoolean) {
            setter = fieldName.startsWith("is") ? "set" + fieldName.substring(2) : "set" + JavaUtils.capitalize(fieldName);
        }
        return setter;
    }

    public static String getterMethodName(String fieldName, boolean isBoolean) {
        String getter = "get" + JavaUtils.capitalize(fieldName);
        if (isBoolean) {
            getter = fieldName.startsWith("is") ? fieldName : "is" + JavaUtils.capitalize(fieldName);
        }
        return getter;
    }

    public static String getGetter(Field field) {
        XmlElement ann = field.getAnnotation(XmlElement.class);
        Class cl = field.getType();
        if (cl.isPrimitive()) {
            cl = JavaUtils.getWrapperType(cl);
        }
        String cap = ann == null || ann.name() == null || ann.name().startsWith("##") ? JavaUtils.capitalize(field.getName()) : JavaUtils.capitalize(ann.name());
        if (cl.getName().equalsIgnoreCase("java.lang.Boolean")) {
            return "is" + cap;
        }
        return "get" + cap;
    }
}

