/*
 * Decompiled with CFR 0.152.
 */
package it.javalinux.wise.core.client.handler;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingHandler
implements SOAPHandler<SOAPMessageContext> {
    private PrintStream outputStream = System.out;

    public LoggingHandler() {
    }

    public LoggingHandler(PrintStream outStream) {
        this.outputStream = outStream;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        this.logToSystemOut(smc);
        return true;
    }

    public boolean handleFault(SOAPMessageContext smc) {
        this.logToSystemOut(smc);
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    private void logToSystemOut(SOAPMessageContext smc) {
        Boolean outboundProperty = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outboundProperty.booleanValue()) {
            this.outputStream.println("\nOutbound message:");
        } else {
            this.outputStream.println("\nInbound message:");
        }
        SOAPMessage message = smc.getMessage();
        try {
            message.writeTo((OutputStream)this.outputStream);
            this.outputStream.println("");
        }
        catch (Exception e) {
            this.outputStream.println("Exception in handler: " + e);
        }
    }

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }
}

