/*
 * Decompiled with CFR 0.152.
 */
package it.javalinux.wise.core.client;

import it.javalinux.wise.core.client.WSMethod;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jws.WebMethod;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class WSEndpoint {
    @GuardedBy(value="this")
    private String name;
    @GuardedBy(value="this")
    private Object instance;
    @GuardedBy(value="this")
    private Class clazz;
    @GuardedBy(value="this")
    private String methodName;
    @GuardedBy(value="this")
    ClassLoader classLoader;

    public synchronized Object getInstance() {
        return this.instance;
    }

    public synchronized void setInstance(Object instance) {
        this.instance = instance;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized String getUrl() {
        return (String)((BindingProvider)this.instance).getRequestContext().get("javax.xml.ws.service.endpoint.address");
    }

    public synchronized void setUrl(String url) {
        ((BindingProvider)this.instance).getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
    }

    public synchronized String getUsername() {
        return (String)((BindingProvider)this.instance).getRequestContext().get("javax.xml.ws.security.auth.username");
    }

    public synchronized void setUsername(String username) {
        ((BindingProvider)this.instance).getRequestContext().put("javax.xml.ws.security.auth.username", username);
    }

    public synchronized String getPassword() {
        return (String)((BindingProvider)this.instance).getRequestContext().get("javax.xml.ws.security.auth.password");
    }

    public synchronized void setPassword(String password) {
        ((BindingProvider)this.instance).getRequestContext().put("javax.xml.ws.security.auth.password", password);
    }

    public synchronized Class getClazz() {
        return this.clazz;
    }

    public synchronized void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public synchronized String getMethodName() {
        return this.methodName;
    }

    public synchronized void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public synchronized void addHandler(Handler handler) {
        List handlerChain = ((BindingProvider)this.instance).getBinding().getHandlerChain();
        handlerChain.add(handler);
        ((BindingProvider)this.instance).getBinding().setHandlerChain(handlerChain);
    }

    public synchronized Map<String, WSMethod> getWSMethods() {
        TreeMap<String, WSMethod> wsMethods = new TreeMap<String, WSMethod>();
        for (Method method : this.getClazz().getMethods()) {
            WebMethod annotation = method.getAnnotation(WebMethod.class);
            if (annotation == null) continue;
            if (annotation.operationName() != null && !annotation.operationName().equals("")) {
                wsMethods.put(annotation.operationName(), new WSMethod(method, this));
                continue;
            }
            wsMethods.put(method.getName(), new WSMethod(method, this));
        }
        return wsMethods;
    }

    public synchronized ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public synchronized void enableMTOM() {
        ((SOAPBinding)((BindingProvider)this.instance).getBinding()).setMTOMEnabled(true);
    }
}

