/*
 * Decompiled with CFR 0.152.
 */
package it.javalinux.wise.core.client;

import it.javalinux.wise.core.client.WSDynamicClient;
import it.javalinux.wise.core.exceptions.WiseConnectionException;
import it.javalinux.wise.core.exceptions.WiseException;
import it.javalinux.wise.core.utils.IDGenerator;
import it.javalinux.wise.core.utils.IOUtils;
import it.javalinux.wise.core.utils.WiseProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import sun.misc.BASE64Encoder;

@ThreadSafe
public class WSDynamicClientFactory {
    private static WSDynamicClientFactory me = null;
    private final Map<String, WSDynamicClient> clientsMap = Collections.synchronizedMap(new HashMap());
    private WiseProperties wiseProperties = new WiseProperties("wise-core.properties");

    private WSDynamicClientFactory() throws WiseException {
    }

    public static synchronized WSDynamicClientFactory getInstace() throws WiseException {
        if (me == null) {
            me = new WSDynamicClientFactory();
        }
        return me;
    }

    public void clearCache() {
        this.clientsMap.clear();
    }

    public WSDynamicClient getClient(String wsdlURL, String name, String userName, String password) throws IllegalArgumentException, WiseConnectionException {
        WSDynamicClient client;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (wsdlURL == null) {
            throw new IllegalArgumentException("wsdlURL cannot be null");
        }
        String usableWsdl = wsdlURL;
        if (wsdlURL != null && wsdlURL.startsWith("http://")) {
            usableWsdl = this.getUsableWSDL(wsdlURL, userName, password);
        }
        if ((client = this.clientsMap.get(name)) == null) {
            client = new WSDynamicClient(this.wiseProperties);
            client.init(usableWsdl, name, userName, password);
            this.clientsMap.put(name, client);
        }
        return client;
    }

    public void setWiseProperties(WiseProperties wiseProperties) {
        this.wiseProperties = wiseProperties;
    }

    String getUsableWSDL(String wsdlURL, String userName, String password) throws WiseConnectionException {
        if (StringUtils.trimToNull((String)userName) == null || StringUtils.trimToNull((String)password) == null) {
            return this.transferWSDL(wsdlURL, null);
        }
        return this.transferWSDL(wsdlURL, new StringBuffer(userName).append(":").append(password).toString());
    }

    private String transferWSDL(String wsdlURL, String userPassword) throws WiseConnectionException {
        String filePath = null;
        try {
            URL endpoint = new URL(wsdlURL);
            HttpURLConnection conn = (HttpURLConnection)endpoint.openConnection();
            conn.setDoOutput(false);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
            conn.setRequestProperty("Connection", "close");
            if (userPassword != null) {
                conn.setRequestProperty("Authorization", "Basic " + new BASE64Encoder().encode(userPassword.getBytes()));
            }
            InputStream is = null;
            if (conn.getResponseCode() != 200) {
                is = conn.getErrorStream();
                InputStreamReader isr = new InputStreamReader(is);
                StringWriter sw = new StringWriter();
                char[] buf = new char[200];
                int read = 0;
                while (read != -1) {
                    read = isr.read(buf);
                    sw.write(buf);
                }
                throw new WiseConnectionException("Remote server's response is an error: " + sw.toString());
            }
            is = conn.getInputStream();
            File file = new File(this.wiseProperties.getProperty("wise.tmpDir"), new StringBuffer("Wise").append(IDGenerator.nextVal()).append(".xml").toString());
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
            IOUtils.copyStream(fos, is);
            ((OutputStream)fos).close();
            is.close();
            filePath = file.getPath();
        }
        catch (WiseConnectionException wce) {
            throw wce;
        }
        catch (Exception e) {
            throw new WiseConnectionException("Wsdl download failed!", e);
        }
        return filePath;
    }
}

