/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.thread;

public final class Valve {
    private final Object mutex = new Object();
    private boolean on;
    private int turningOff = 0;
    private int usage = 0;

    public Valve(boolean on) {
        this.on = on;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnOn() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.on) {
                this.mutex.wait();
            }
            this.on = true;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOn() {
        Object object = this.mutex;
        synchronized (object) {
            return this.on;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnOff() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            try {
                ++this.turningOff;
                while (this.usage > 0 || !this.on) {
                    this.mutex.wait();
                }
                this.on = false;
                this.mutex.notifyAll();
            }
            finally {
                --this.turningOff;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.turningOff > 0 || !this.on) {
                this.mutex.wait();
            }
            ++this.usage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement() {
        Object object = this.mutex;
        synchronized (object) {
            --this.usage;
            if (this.turningOff > 0 && this.usage < 1) {
                this.mutex.notifyAll();
            }
        }
    }
}

