/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.pool.ConnectionKey;
import org.apache.activemq.pool.ConnectionPool;
import org.apache.activemq.pool.PooledConnection;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.pool.ObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPoolFactory;

public class PooledConnectionFactory
implements ConnectionFactory,
Service {
    private ActiveMQConnectionFactory connectionFactory;
    private Map cache = new HashMap();
    private ObjectPoolFactory poolFactory;
    private int maximumActive = 5000;

    public PooledConnectionFactory() {
        this(new ActiveMQConnectionFactory());
    }

    public PooledConnectionFactory(String brokerURL) {
        this(new ActiveMQConnectionFactory(brokerURL));
    }

    public PooledConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public synchronized Connection createConnection(String userName, String password) throws JMSException {
        ConnectionKey key = new ConnectionKey(userName, password);
        ConnectionPool connection = (ConnectionPool)this.cache.get(key);
        if (connection == null) {
            ActiveMQConnection delegate = this.createConnection(key);
            connection = new ConnectionPool(delegate, this.getPoolFactory());
            this.cache.put(key, connection);
        }
        return new PooledConnection(connection);
    }

    protected ActiveMQConnection createConnection(ConnectionKey key) throws JMSException {
        if (key.getUserName() == null && key.getPassword() == null) {
            return (ActiveMQConnection)this.connectionFactory.createConnection();
        }
        return (ActiveMQConnection)this.connectionFactory.createConnection(key.getUserName(), key.getPassword());
    }

    public void start() {
        try {
            this.createConnection();
        }
        catch (JMSException e) {
            IOExceptionSupport.create((Exception)((Object)e));
        }
    }

    public void stop() throws Exception {
        ServiceStopper stopper = new ServiceStopper();
        Iterator iter = this.cache.values().iterator();
        while (iter.hasNext()) {
            ConnectionPool connection = (ConnectionPool)iter.next();
            try {
                connection.close();
            }
            catch (JMSException e) {
                stopper.onException(this, e);
            }
        }
        stopper.throwFirstException();
    }

    public ObjectPoolFactory getPoolFactory() {
        if (this.poolFactory == null) {
            this.poolFactory = this.createPoolFactory();
        }
        return this.poolFactory;
    }

    public void setPoolFactory(ObjectPoolFactory poolFactory) {
        this.poolFactory = poolFactory;
    }

    public int getMaximumActive() {
        return this.maximumActive;
    }

    public void setMaximumActive(int maximumActive) {
        this.maximumActive = maximumActive;
    }

    protected ObjectPoolFactory createPoolFactory() {
        return new GenericObjectPoolFactory(null, this.maximumActive);
    }
}

