/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.IOException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.management.ObjectName;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.filter.LogicExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.filter.NoLocalExpression;
import org.apache.activemq.selector.SelectorParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractSubscription
implements Subscription {
    private static final Log log = LogFactory.getLog((Class)AbstractSubscription.class);
    protected Broker broker;
    protected ConnectionContext context;
    protected ConsumerInfo info;
    protected final DestinationFilter destinationFilter;
    private BooleanExpression selectorExpression;
    private ObjectName objectName;
    protected final CopyOnWriteArrayList destinations = new CopyOnWriteArrayList();

    public AbstractSubscription(Broker broker, ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        this.broker = broker;
        this.context = context;
        this.info = info;
        this.destinationFilter = DestinationFilter.parseFilter(info.getDestination());
        this.selectorExpression = AbstractSubscription.parseSelector(info);
    }

    private static BooleanExpression parseSelector(ConsumerInfo info) throws InvalidSelectorException {
        BooleanExpression rc = null;
        if (info.getSelector() != null) {
            rc = new SelectorParser().parse(info.getSelector());
        }
        if (info.isNoLocal()) {
            rc = rc == null ? new NoLocalExpression(info.getConsumerId().getConnectionId()) : LogicExpression.createAND(new NoLocalExpression(info.getConsumerId().getConnectionId()), rc);
        }
        if (info.getAdditionalPredicate() != null) {
            rc = rc == null ? info.getAdditionalPredicate() : LogicExpression.createAND(info.getAdditionalPredicate(), rc);
        }
        return rc;
    }

    public boolean matches(MessageReference node, MessageEvaluationContext context) throws IOException {
        ConsumerId targetConsumerId = node.getTargetConsumerId();
        if (targetConsumerId != null && !targetConsumerId.equals(this.info.getConsumerId())) {
            return false;
        }
        try {
            return (this.selectorExpression == null || this.selectorExpression.matches(context)) && this.context.isAllowedToConsume(node);
        }
        catch (JMSException e) {
            log.info((Object)("Selector failed to evaluate: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public boolean matches(ActiveMQDestination destination) {
        return this.destinationFilter.matches(destination);
    }

    public void add(ConnectionContext context, Destination destination) throws Exception {
        this.destinations.add((Object)destination);
    }

    public void remove(ConnectionContext context, Destination destination) throws Exception {
        this.destinations.remove((Object)destination);
    }

    public ConsumerInfo getConsumerInfo() {
        return this.info;
    }

    public void gc() {
    }

    public boolean isSlaveBroker() {
        return this.broker.isSlaveBroker();
    }

    public ConnectionContext getContext() {
        return this.context;
    }

    public ConsumerInfo getInfo() {
        return this.info;
    }

    public BooleanExpression getSelectorExpression() {
        return this.selectorExpression;
    }

    public String getSelector() {
        return this.info.getSelector();
    }

    public void setSelector(String selector) throws InvalidSelectorException {
        ConsumerInfo copy = this.info.copy();
        copy.setSelector(selector);
        BooleanExpression newSelector = AbstractSubscription.parseSelector(copy);
        this.info.setSelector(selector);
        this.selectorExpression = newSelector;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public int getPrefetchSize() {
        return this.info.getPrefetchSize();
    }

    public boolean isRecoveryRequired() {
        return true;
    }
}

