/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.jpetstore.web.spring;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.samples.jpetstore.domain.logic.PetStoreFacade;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class SearchProductsController
implements Controller {
    private PetStoreFacade petStore;

    public void setPetStore(PetStoreFacade petStore) {
        this.petStore = petStore;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String keyword = request.getParameter("keyword");
        if (keyword != null) {
            if (!StringUtils.hasLength((String)keyword)) {
                return new ModelAndView("Error", "message", (Object)"Please enter a keyword to search for, then press the search button.");
            }
            PagedListHolder productList = new PagedListHolder(this.petStore.searchProductList(keyword.toLowerCase()));
            productList.setPageSize(4);
            request.getSession().setAttribute("SearchProductsController_productList", (Object)productList);
            return new ModelAndView("SearchProducts", "productList", (Object)productList);
        }
        String page = request.getParameter("page");
        PagedListHolder productList = (PagedListHolder)request.getSession().getAttribute("SearchProductsController_productList");
        if (productList == null) {
            return new ModelAndView("Error", "message", (Object)"Your session has timed out. Please start over again.");
        }
        if ("next".equals(page)) {
            productList.nextPage();
        } else if ("previous".equals(page)) {
            productList.previousPage();
        }
        return new ModelAndView("SearchProducts", "productList", (Object)productList);
    }
}

