/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.asm;

import java.util.List;
import org.drools.asm.AnnotationVisitor;
import org.drools.asm.Attribute;
import org.drools.asm.ClassReader;
import org.drools.asm.ClassVisitor;
import org.drools.asm.FieldVisitor;
import org.drools.asm.MethodVisitor;
import org.drools.asm.util.TraceMethodVisitor;

public class MethodComparator {
    public boolean equivalent(String string, ClassReader classReader, String string2, ClassReader classReader2) {
        List list = this.getMethodBytecode(string, classReader);
        List list2 = this.getMethodBytecode(string2, classReader2);
        return MethodComparator.compareBytecode(list, list2);
    }

    public List getMethodBytecode(String string, ClassReader classReader) {
        Tracer tracer = new Tracer(string);
        classReader.accept(tracer, true);
        TraceMethodVisitor traceMethodVisitor = tracer.getTrace();
        return traceMethodVisitor.getText();
    }

    public static List getMethodBytecode(String string, byte[] byArray) {
        Tracer tracer = new Tracer(string);
        ClassReader classReader = new ClassReader(byArray);
        classReader.accept(tracer, true);
        TraceMethodVisitor traceMethodVisitor = tracer.getTrace();
        return traceMethodVisitor.getText();
    }

    public static boolean compareBytecode(List list, List list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).equals(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    static class DummyAnnotationVisitor
    implements AnnotationVisitor {
        DummyAnnotationVisitor() {
        }

        public void visit(String string, Object object) {
        }

        public AnnotationVisitor visitAnnotation(String string, String string2) {
            return new DummyAnnotationVisitor();
        }

        public AnnotationVisitor visitArray(String string) {
            return new DummyAnnotationVisitor();
        }

        public void visitEnd() {
        }

        public void visitEnum(String string, String string2, String string3) {
        }
    }

    public static class Tracer
    implements ClassVisitor {
        private TraceMethodVisitor trace;
        private String methodName;

        public Tracer(String string) {
            this.methodName = string;
        }

        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        }

        public AnnotationVisitor visitAnnotation(String string, boolean bl) {
            return new DummyAnnotationVisitor();
        }

        public void visitAttribute(Attribute attribute) {
        }

        public void visitEnd() {
        }

        public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
            return null;
        }

        public void visitInnerClass(String string, String string2, String string3, int n) {
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if (this.methodName.equals(string)) {
                this.trace = new TraceMethodVisitor();
                return this.trace;
            }
            return null;
        }

        public void visitOuterClass(String string, String string2, String string3) {
        }

        public void visitSource(String string, String string2) {
        }

        public TraceMethodVisitor getTrace() {
            return this.trace;
        }
    }
}

