/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import org.drools.base.evaluators.ArrayFactory;
import org.drools.base.evaluators.BooleanFactory;
import org.drools.base.evaluators.ByteFactory;
import org.drools.base.evaluators.CharacterFactory;
import org.drools.base.evaluators.DateFactory;
import org.drools.base.evaluators.DoubleFactory;
import org.drools.base.evaluators.FloatFactory;
import org.drools.base.evaluators.IntegerFactory;
import org.drools.base.evaluators.LongFactory;
import org.drools.base.evaluators.ObjectFactory;
import org.drools.base.evaluators.ShortFactory;
import org.drools.base.evaluators.StringFactory;
import org.drools.spi.Evaluator;

public class EvaluatorFactory {
    private static final EvaluatorFactory INSTANCE = new EvaluatorFactory();

    public static EvaluatorFactory getInstance() {
        return INSTANCE;
    }

    private EvaluatorFactory() {
    }

    public static Evaluator getEvaluator(int n, String string) {
        Evaluator evaluator = null;
        if (string.equals("==")) {
            evaluator = EvaluatorFactory.getEvaluator(n, 1);
        } else if (string.equals("!=")) {
            evaluator = EvaluatorFactory.getEvaluator(n, 10);
        } else if (string.equals("<")) {
            evaluator = EvaluatorFactory.getEvaluator(n, 20);
        } else if (string.equals("<=")) {
            evaluator = EvaluatorFactory.getEvaluator(n, 30);
        } else if (string.equals(">")) {
            evaluator = EvaluatorFactory.getEvaluator(n, 40);
        } else if (string.equals(">=")) {
            evaluator = EvaluatorFactory.getEvaluator(n, 50);
        } else if (string.equals("contains")) {
            evaluator = EvaluatorFactory.getEvaluator(n, 60);
        } else if (string.equals("matches")) {
            evaluator = EvaluatorFactory.getEvaluator(n, 70);
        } else if (string.equals("excludes")) {
            evaluator = EvaluatorFactory.getEvaluator(n, 80);
        } else {
            throw new IllegalArgumentException("Unknown operator: '" + string + "'");
        }
        return evaluator;
    }

    public static Evaluator getEvaluator(int n, int n2) {
        switch (n) {
            case 180: {
                return StringFactory.getStringEvaluator(n2);
            }
            case 210: {
                return ObjectFactory.getObjectEvaluator(n2);
            }
            case 120: {
                return ShortFactory.getShortEvaluator(n2);
            }
            case 130: {
                return IntegerFactory.getIntegerEvaluator(n2);
            }
            case 170: {
                return BooleanFactory.getBooleanEvaluator(n2);
            }
            case 160: {
                return DoubleFactory.getDoubleEvaluator(n2);
            }
            case 100: {
                return CharacterFactory.getCharacterEvaluator(n2);
            }
            case 110: {
                return ByteFactory.getByteEvaluator(n2);
            }
            case 150: {
                return FloatFactory.getFloatEvaluator(n2);
            }
            case 140: {
                return LongFactory.getLongEvaluator(n2);
            }
            case 190: {
                return DateFactory.getDateEvaluator(n2);
            }
            case 200: {
                return ArrayFactory.getArrayEvaluator(n2);
            }
        }
        throw new RuntimeException("Type '" + n + "' does not exist for BaseEvaluatorFactory");
    }
}

