/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.juddi.api_v3.DeletePublisher;
import org.apache.juddi.api_v3.GetAllPublisherDetail;
import org.apache.juddi.api_v3.GetPublisherDetail;
import org.apache.juddi.api_v3.Publisher;
import org.apache.juddi.api_v3.SavePublisher;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.v3.error.UserMismatchException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidateUDDIApi;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class ValidatePublisher
extends ValidateUDDIApi {
    public ValidatePublisher(UddiEntityPublisher publisher) {
        super(publisher);
    }

    public void validateDeletePublisher(EntityManager em, DeletePublisher body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getPublisherId();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        if (!((org.apache.juddi.model.Publisher)this.publisher).isAdmin()) {
            throw new UserMismatchException(new ErrorMessage("errors.deletepublisher.AdminReqd"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (String entityKey : entityKeyList) {
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(org.apache.juddi.model.Publisher.class, (Object)entityKey);
            if (obj != null) continue;
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.PublisherNotFound", entityKey));
        }
    }

    public void validateSavePublisher(EntityManager em, SavePublisher body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityList = body.getPublisher();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.savepublisher.NoInput"));
        }
        if (!((org.apache.juddi.model.Publisher)this.publisher).isAdmin()) {
            throw new UserMismatchException(new ErrorMessage("errors.savepublisher.AdminReqd"));
        }
        for (Publisher entity : entityList) {
            this.validatePublisher(em, entity);
        }
    }

    public void validatePublisher(EntityManager em, Publisher publisher) throws DispositionReportFaultMessage {
        if (publisher == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.publisher.NullInput"));
        }
        String authorizedName = publisher.getAuthorizedName();
        if (authorizedName == null || authorizedName.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.publisher.NoAuthorizedName"));
        }
        String publisherName = publisher.getPublisherName();
        if (publisherName == null || publisherName.length() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.publisher.NoPublisherName"));
        }
    }

    public void validateGetPublisherDetail(GetPublisherDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List publisherIdList = body.getPublisherId();
        if (publisherIdList == null || publisherIdList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (String publisherId : publisherIdList) {
            boolean inserted = dupCheck.add(publisherId);
            if (inserted) continue;
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", publisherId));
        }
    }

    public void validateGetAllPublisherDetail(GetAllPublisherDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
    }
}

