/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.io.StringWriter;
import java.io.Writer;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.XRegisterHelper;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.ClientSubscriptionInfo;
import org.apache.juddi.subscription.NotificationList;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.validation.ValidateSubscriptionListener;
import org.apache.log4j.Logger;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.Result;
import org.uddi.subr_v3.NotifySubscriptionListener;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;

@WebService(serviceName="UDDISubscriptionListenerService", endpointInterface="org.uddi.v3_service.UDDISubscriptionListenerPortType", targetNamespace="urn:uddi-org:v3_service")
public class UDDISubscriptionListenerImpl
extends AuthenticatedService
implements UDDISubscriptionListenerPortType {
    private static Logger logger = Logger.getLogger(UDDISubscriptionListenerImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispositionReport notifySubscriptionListener(NotifySubscriptionListener body) throws DispositionReportFaultMessage {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{body.getClass()});
            Marshaller marshaller = context.createMarshaller();
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)body, (Writer)sw);
            logger.info((Object)("Notification received by UDDISubscriptionListenerService : " + sw.toString()));
            NotificationList<String> nl = NotificationList.getInstance();
            nl.getNotifications().add((Object)sw.toString());
            org.apache.juddi.api_v3.ClientSubscriptionInfo apiClientSubscriptionInfo = null;
            EntityManager em = PersistenceManager.getEntityManager();
            EntityTransaction tx = em.getTransaction();
            try {
                tx.begin();
                this.getEntityPublisher(em, body.getAuthInfo());
                String subscriptionKey = body.getSubscriptionResultsList().getSubscription().getSubscriptionKey();
                ClientSubscriptionInfo modelClientSubscriptionInfo = (ClientSubscriptionInfo)em.find(ClientSubscriptionInfo.class, (Object)subscriptionKey);
                if (modelClientSubscriptionInfo == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.SubscripKeyNotFound", subscriptionKey));
                }
                apiClientSubscriptionInfo = new org.apache.juddi.api_v3.ClientSubscriptionInfo();
                MappingModelToApi.mapClientSubscriptionInfo(modelClientSubscriptionInfo, apiClientSubscriptionInfo);
                tx.commit();
            }
            finally {
                if (tx.isActive()) {
                    tx.rollback();
                }
                em.close();
            }
            XRegisterHelper.handle(apiClientSubscriptionInfo.getFromClerk(), apiClientSubscriptionInfo.getToClerk(), body.getSubscriptionResultsList());
        }
        catch (JAXBException jaxbe) {
            logger.error((Object)"", (Throwable)jaxbe);
            throw new FatalErrorException(new ErrorMessage("errors.subscriptionnotifier.client"));
        }
        new ValidateSubscriptionListener().validateNotification(body);
        DispositionReport dr = new DispositionReport();
        Result res = new Result();
        dr.getResult().add(res);
        return dr;
    }
}

