/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.List;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.InquiryHelper;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.validation.ValidateInquiry;
import org.apache.log4j.Logger;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetOperationalInfo;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.OperationalInfo;
import org.uddi.api_v3.OperationalInfos;
import org.uddi.api_v3.RelatedBusinessesList;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelList;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIInquiryPortType;

@WebService(serviceName="UDDIInquiryService", endpointInterface="org.uddi.v3_service.UDDIInquiryPortType", targetNamespace="urn:uddi-org:v3_service")
public class UDDIInquiryImpl
extends AuthenticatedService
implements UDDIInquiryPortType {
    private static Logger log = Logger.getLogger(UDDIInquiryImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingDetail findBinding(FindBinding body) throws DispositionReportFaultMessage {
        new ValidateInquiry(null).validateFindBinding(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            List<?> keysFound = InquiryHelper.findBinding(body, findQualifiers, em);
            BindingDetail result = InquiryHelper.getBindingDetailFromKeys(body, findQualifiers, em, keysFound);
            tx.commit();
            BindingDetail bindingDetail = result;
            return bindingDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessList findBusiness(FindBusiness body) throws DispositionReportFaultMessage {
        new ValidateInquiry(null).validateFindBusiness(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            List<?> keysFound = InquiryHelper.findBusiness(body, findQualifiers, em);
            BusinessList result = InquiryHelper.getBusinessListFromKeys(body, findQualifiers, em, keysFound);
            tx.commit();
            BusinessList businessList = result;
            return businessList;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelatedBusinessesList findRelatedBusinesses(FindRelatedBusinesses body) throws DispositionReportFaultMessage {
        new ValidateInquiry(null).validateFindRelatedBusinesses(body, false);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            RelatedBusinessesList result = InquiryHelper.getRelatedBusinessesList(body, em);
            tx.commit();
            RelatedBusinessesList relatedBusinessesList = result;
            return relatedBusinessesList;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceList findService(FindService body) throws DispositionReportFaultMessage {
        new ValidateInquiry(null).validateFindService(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            List<?> keysFound = InquiryHelper.findService(body, findQualifiers, em);
            ServiceList result = InquiryHelper.getServiceListFromKeys(body, findQualifiers, em, keysFound);
            tx.commit();
            ServiceList serviceList = result;
            return serviceList;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TModelList findTModel(FindTModel body) throws DispositionReportFaultMessage {
        new ValidateInquiry(null).validateFindTModel(body, false);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(body.getFindQualifiers());
            List<?> keysFound = InquiryHelper.findTModel(body, findQualifiers, em);
            TModelList result = InquiryHelper.getTModelListFromKeys(body, findQualifiers, em, keysFound);
            tx.commit();
            TModelList tModelList = result;
            return tModelList;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingDetail getBindingDetail(GetBindingDetail body) throws DispositionReportFaultMessage {
        new ValidateInquiry(null).validateGetBindingDetail(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            BindingDetail result = new BindingDetail();
            List bindingKeyList = body.getBindingKey();
            for (String bindingKey : bindingKeyList) {
                BindingTemplate modelBindingTemplate = (BindingTemplate)em.find(BindingTemplate.class, (Object)bindingKey);
                if (modelBindingTemplate == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BindingTemplateNotFound", bindingKey));
                }
                org.uddi.api_v3.BindingTemplate apiBindingTemplate = new org.uddi.api_v3.BindingTemplate();
                MappingModelToApi.mapBindingTemplate(modelBindingTemplate, apiBindingTemplate);
                result.getBindingTemplate().add(apiBindingTemplate);
            }
            tx.commit();
            BindingDetail bindingDetail = result;
            return bindingDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessDetail getBusinessDetail(GetBusinessDetail body) throws DispositionReportFaultMessage {
        new ValidateInquiry(null).validateGetBusinessDetail(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            BusinessDetail result = new BusinessDetail();
            List businessKeyList = body.getBusinessKey();
            for (String businessKey : businessKeyList) {
                BusinessEntity modelBusinessEntity = (BusinessEntity)em.find(BusinessEntity.class, (Object)businessKey);
                if (modelBusinessEntity == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", businessKey));
                }
                org.uddi.api_v3.BusinessEntity apiBusinessEntity = new org.uddi.api_v3.BusinessEntity();
                MappingModelToApi.mapBusinessEntity(modelBusinessEntity, apiBusinessEntity);
                result.getBusinessEntity().add(apiBusinessEntity);
            }
            tx.commit();
            BusinessDetail businessDetail = result;
            return businessDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationalInfos getOperationalInfo(GetOperationalInfo body) throws DispositionReportFaultMessage {
        new ValidateInquiry(null).validateGetOperationalInfo(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            OperationalInfos result = new OperationalInfos();
            List entityKeyList = body.getEntityKey();
            for (String entityKey : entityKeyList) {
                UddiEntity modelUddiEntity = (UddiEntity)em.find(UddiEntity.class, (Object)entityKey);
                if (modelUddiEntity == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.EntityNotFound", entityKey));
                }
                OperationalInfo apiOperationalInfo = new OperationalInfo();
                MappingModelToApi.mapOperationalInfo(modelUddiEntity, apiOperationalInfo);
                result.getOperationalInfo().add(apiOperationalInfo);
            }
            tx.commit();
            OperationalInfos operationalInfos = result;
            return operationalInfos;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDetail getServiceDetail(GetServiceDetail body) throws DispositionReportFaultMessage {
        new ValidateInquiry(null).validateGetServiceDetail(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            ServiceDetail result = new ServiceDetail();
            List serviceKeyList = body.getServiceKey();
            for (String serviceKey : serviceKeyList) {
                BusinessService modelBusinessService = (BusinessService)em.find(BusinessService.class, (Object)serviceKey);
                if (modelBusinessService == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceNotFound", serviceKey));
                }
                org.uddi.api_v3.BusinessService apiBusinessService = new org.uddi.api_v3.BusinessService();
                MappingModelToApi.mapBusinessService(modelBusinessService, apiBusinessService);
                result.getBusinessService().add(apiBusinessService);
            }
            tx.commit();
            ServiceDetail serviceDetail = result;
            return serviceDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TModelDetail getTModelDetail(GetTModelDetail body) throws DispositionReportFaultMessage {
        new ValidateInquiry(null).validateGetTModelDetail(body);
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            if (this.isAuthenticated()) {
                this.getEntityPublisher(em, body.getAuthInfo());
            }
            TModelDetail result = new TModelDetail();
            List tmodelKeyList = body.getTModelKey();
            for (String tmodelKey : tmodelKeyList) {
                Tmodel modelTModel = (Tmodel)em.find(Tmodel.class, (Object)tmodelKey);
                if (modelTModel == null) {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", tmodelKey));
                }
                TModel apiTModel = new TModel();
                MappingModelToApi.mapTModel(modelTModel, apiTModel);
                result.getTModel().add(apiTModel);
            }
            tx.commit();
            TModelDetail tModelDetail = result;
            return tModelDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    private boolean isAuthenticated() {
        boolean result = false;
        try {
            result = AppConfig.getConfiguration().getBoolean("juddi.authenticate.Inquiry");
        }
        catch (ConfigurationException e) {
            log.error((Object)"Configuration exception occurred retrieving: juddi.authenticate.Inquiry", (Throwable)e);
        }
        return result;
    }
}

