/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import org.jruby.Finalizable;
import org.jruby.Ruby;
import org.jruby.util.ByteList;
import org.jruby.util.JRubyFile;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.NullChannel;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.Stream;

public class ChannelStream
implements Stream,
Finalizable {
    private static final boolean DEBUG = false;
    private static final int BUFSIZE = 4096;
    private static final int BULK_READ_SIZE = 16384;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private Ruby runtime;
    protected ModeFlags modes;
    protected boolean sync = false;
    protected volatile ByteBuffer buffer;
    protected boolean reading;
    private ChannelDescriptor descriptor;
    private boolean blocking = true;
    protected int ungotc = -1;
    private volatile boolean closedExplicitly = false;
    private boolean eof = false;

    public ChannelStream(Ruby runtime, ChannelDescriptor descriptor, ModeFlags modes, FileDescriptor fileDescriptor) throws InvalidValueException {
        descriptor.checkNewModes(modes);
        this.runtime = runtime;
        this.descriptor = descriptor;
        this.modes = modes;
        this.buffer = ByteBuffer.allocate(4096);
        this.buffer.flip();
        this.reading = true;
    }

    public ChannelStream(Ruby runtime, ChannelDescriptor descriptor) {
        this(runtime, descriptor, descriptor.getFileDescriptor());
    }

    public ChannelStream(Ruby runtime, ChannelDescriptor descriptor, FileDescriptor fileDescriptor) {
        this.runtime = runtime;
        this.descriptor = descriptor;
        this.modes = descriptor.getOriginalModes();
        this.buffer = ByteBuffer.allocate(4096);
        this.buffer.flip();
        this.reading = true;
    }

    public ChannelStream(Ruby runtime, ChannelDescriptor descriptor, ModeFlags modes) throws InvalidValueException {
        descriptor.checkNewModes(modes);
        this.runtime = runtime;
        this.descriptor = descriptor;
        this.modes = modes;
        this.buffer = ByteBuffer.allocate(4096);
        this.buffer.flip();
        this.reading = true;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public void checkReadable() throws IOException {
        if (!this.modes.isReadable()) {
            throw new IOException("not opened for reading");
        }
    }

    public void checkWritable() throws IOException {
        if (!this.modes.isWritable()) {
            throw new IOException("not opened for writing");
        }
    }

    public void checkPermissionsSubsetOf(ModeFlags subsetModes) {
        subsetModes.isSubsetOf(this.modes);
    }

    public ModeFlags getModes() {
        return this.modes;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public void waitUntilReady() throws IOException, InterruptedException {
        while (this.ready() == 0) {
            Thread.sleep(10L);
        }
    }

    public boolean readDataBuffered() {
        return this.reading && this.buffer.hasRemaining();
    }

    public boolean writeDataBuffered() {
        return !this.reading && this.buffer.position() > 0;
    }

    private final int refillBuffer() throws IOException {
        this.buffer.clear();
        int n = ((ReadableByteChannel)this.descriptor.getChannel()).read(this.buffer);
        this.buffer.flip();
        return n;
    }

    public synchronized ByteList fgets(ByteList separatorString) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        if (separatorString == null) {
            return this.readall();
        }
        ByteList separator = separatorString == PARAGRAPH_DELIMETER ? PARAGRAPH_SEPARATOR : separatorString;
        this.descriptor.checkOpen();
        if (this.feof()) {
            return null;
        }
        int c = this.read();
        if (c == -1) {
            return null;
        }
        this.buffer.position(this.buffer.position() - 1);
        ByteList buf = new ByteList(40);
        byte first = separator.bytes[separator.begin];
        block0: while (true) {
            block11: {
                byte[] bytes = this.buffer.array();
                int offset = this.buffer.position();
                int max = this.buffer.limit();
                for (int i = offset; i < max; ++i) {
                    c = bytes[i];
                    if (c != first) continue;
                    buf.append(bytes, offset, i - offset);
                    if (i >= max) {
                        this.buffer.clear();
                    } else {
                        this.buffer.position(i + 1);
                    }
                    break block11;
                }
                buf.append(bytes, offset, this.buffer.remaining());
                int read = this.refillBuffer();
                if (read != -1) continue;
                break;
            }
            for (int i = 0; i < separator.realSize && c != -1; ++i) {
                if (c != separator.bytes[separator.begin + i]) {
                    buf.append(c);
                    continue block0;
                }
                buf.append(c);
                if (i >= separator.realSize - 1) continue;
                c = this.read();
            }
            break;
        }
        if (separatorString == PARAGRAPH_DELIMETER) {
            while (c == separator.bytes[separator.begin]) {
                c = this.read();
            }
            this.ungetc(c);
        }
        return buf;
    }

    public synchronized int getline(ByteList dst, byte terminator) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        this.descriptor.checkOpen();
        int totalRead = 0;
        boolean found = false;
        if (this.ungotc != -1) {
            dst.append((byte)this.ungotc);
            found = this.ungotc == terminator;
            this.ungotc = -1;
            ++totalRead;
        }
        while (!found) {
            int n;
            byte[] bytes = this.buffer.array();
            int begin = this.buffer.arrayOffset() + this.buffer.position();
            int end = begin + this.buffer.remaining();
            int len = 0;
            for (int i = begin; i < end && !found; ++i) {
                found = bytes[i] == terminator;
                ++len;
            }
            if (len > 0) {
                dst.append(this.buffer, len);
                totalRead += len;
            }
            if (found || (n = this.refillBuffer()) > 0) continue;
            if (n >= 0 || totalRead >= 1) break;
            return -1;
        }
        return totalRead;
    }

    public synchronized ByteList readall() throws IOException, BadDescriptorException {
        if (this.descriptor.isSeekable()) {
            int n;
            this.invalidateBuffer();
            FileChannel channel = (FileChannel)this.descriptor.getChannel();
            long left = channel.size() - channel.position();
            if (left <= 0L) {
                this.eof = true;
                return null;
            }
            ByteList result = new ByteList((int)(left += this.ungotc != -1 ? 1L : 0L));
            ByteBuffer buf = ByteBuffer.wrap(result.unsafeBytes(), result.begin(), (int)left);
            if (this.ungotc != -1) {
                buf.put((byte)this.ungotc);
                this.ungotc = -1;
            }
            while (buf.hasRemaining() && (n = ((ReadableByteChannel)this.descriptor.getChannel()).read(buf)) > 0) {
            }
            this.eof = true;
            result.length(buf.position());
            return result;
        }
        if (this.descriptor.isNull()) {
            return new ByteList(0);
        }
        this.checkReadable();
        ByteList byteList = new ByteList();
        ByteList read = this.fread(4096);
        if (read == null) {
            this.eof = true;
            return byteList;
        }
        while (read != null) {
            byteList.append(read);
            read = this.fread(4096);
        }
        return byteList;
    }

    public synchronized void fclose() throws IOException, BadDescriptorException {
        this.closedExplicitly = true;
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean finalizing) throws IOException, BadDescriptorException {
        try {
            this.flushWrite();
            this.descriptor.close();
            this.buffer = EMPTY_BUFFER;
        }
        finally {
            if (!finalizing) {
                this.getRuntime().removeInternalFinalizer(this);
            }
        }
    }

    private void closeForFinalize() {
        try {
            this.close(true);
        }
        catch (BadDescriptorException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized int fflush() throws IOException, BadDescriptorException {
        this.checkWritable();
        try {
            this.flushWrite();
        }
        catch (EOFException eof) {
            return -1;
        }
        return 0;
    }

    private void flushWrite() throws IOException, BadDescriptorException {
        if (this.reading || !this.modes.isWritable() || this.buffer.position() == 0) {
            return;
        }
        int len = this.buffer.position();
        this.buffer.flip();
        int n = this.descriptor.write(this.buffer);
        if (n != len) {
            // empty if block
        }
        this.buffer.clear();
    }

    public InputStream newInputStream() {
        InputStream in = this.descriptor.getBaseInputStream();
        if (in == null) {
            return new BufferedInputStream(Channels.newInputStream((ReadableByteChannel)this.descriptor.getChannel()));
        }
        return in;
    }

    public OutputStream newOutputStream() {
        return new BufferedOutputStream(Channels.newOutputStream((WritableByteChannel)this.descriptor.getChannel()));
    }

    public void clearerr() {
        this.eof = false;
    }

    public synchronized boolean feof() throws IOException, BadDescriptorException {
        this.checkReadable();
        return this.eof;
    }

    public synchronized long fgetpos() throws IOException, PipeException, InvalidValueException, BadDescriptorException {
        if (this.descriptor.isSeekable()) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            long pos = fileChannel.position();
            if (this.reading) {
                return pos - (long)((pos -= (long)this.buffer.remaining()) > 0L && this.ungotc != -1 ? 1 : 0);
            }
            return pos + (long)this.buffer.position();
        }
        if (this.descriptor.isNull()) {
            return 0L;
        }
        throw new PipeException();
    }

    public synchronized void lseek(long offset, int type) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        if (this.descriptor.isSeekable()) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            this.ungotc = -1;
            int adj = 0;
            if (this.reading) {
                adj = this.buffer.remaining();
                this.buffer.clear();
                this.buffer.flip();
            } else {
                this.flushWrite();
            }
            try {
                switch (type) {
                    case 0: {
                        fileChannel.position(offset);
                        break;
                    }
                    case 1: {
                        fileChannel.position(fileChannel.position() - (long)adj + offset);
                        break;
                    }
                    case 2: {
                        fileChannel.position(fileChannel.size() + offset);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new InvalidValueException();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw ioe;
            }
        } else if (this.descriptor.getChannel() instanceof SelectableChannel) {
            throw new PipeException();
        }
    }

    public void sync() throws IOException, BadDescriptorException {
        this.flushWrite();
    }

    private void ensureRead() throws IOException, BadDescriptorException {
        if (this.reading) {
            return;
        }
        this.flushWrite();
        this.buffer.clear();
        this.buffer.flip();
        this.reading = true;
    }

    private void ensureReadNonBuffered() throws IOException, BadDescriptorException {
        if (this.reading) {
            if (this.buffer.hasRemaining()) {
                throw this.getRuntime().newIOError("sysread for buffered IO");
            }
        } else {
            this.flushWrite();
            this.buffer.clear();
            this.buffer.flip();
            this.reading = true;
        }
    }

    private void resetForWrite() throws IOException {
        if (this.descriptor.isSeekable()) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            if (this.buffer.hasRemaining()) {
                fileChannel.position(fileChannel.position() - (long)this.buffer.remaining());
            }
        }
        this.buffer.clear();
        this.reading = false;
    }

    private void ensureWrite() throws IOException {
        if (!this.reading) {
            return;
        }
        this.resetForWrite();
    }

    public synchronized ByteList read(int number) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureReadNonBuffered();
        ByteList byteList = new ByteList(number);
        int bytesRead = this.descriptor.read(number, byteList);
        if (bytesRead == -1) {
            this.eof = true;
        }
        return byteList;
    }

    private ByteList bufferedRead(int number) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        ByteList result = new ByteList(0);
        int len = -1;
        if (this.buffer.hasRemaining()) {
            len = number <= this.buffer.remaining() ? number : this.buffer.remaining();
            result.append(this.buffer, len);
        }
        boolean done = false;
        while (number - result.length() >= 4096) {
            int bytesToRead = Math.min(16384, number - result.length());
            int n = this.descriptor.read(bytesToRead, result);
            if (n == -1) {
                this.eof = true;
                done = true;
                break;
            }
            if (n != 0) continue;
            done = true;
            break;
        }
        while (!done && result.length() != number) {
            int read = this.refillBuffer();
            if (read == -1) {
                this.eof = true;
                break;
            }
            if (read == 0) break;
            int desired = number - result.length();
            len = desired < read ? desired : read;
            result.append(this.buffer, len);
        }
        if (result.length() == 0 && number != 0 && this.eof) {
            throw new EOFException();
        }
        return result;
    }

    private int bufferedRead() throws IOException, BadDescriptorException {
        this.ensureRead();
        if (!this.buffer.hasRemaining()) {
            int len = this.refillBuffer();
            if (len == -1) {
                this.eof = true;
                return -1;
            }
            if (len == 0) {
                return -1;
            }
        }
        return this.buffer.get() & 0xFF;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int bufferedWrite(ByteList buf) throws IOException, BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWritable();
        this.ensureWrite();
        if (buf == null || buf.length() == 0) {
            return 0;
        }
        if (buf.length() > this.buffer.capacity()) {
            this.flushWrite();
            int n = this.descriptor.write(ByteBuffer.wrap(buf.unsafeBytes(), buf.begin(), buf.length()));
            if (n == buf.length()) {
                // empty if block
            }
        } else {
            if (buf.length() > this.buffer.remaining()) {
                this.flushWrite();
            }
            this.buffer.put(buf.unsafeBytes(), buf.begin(), buf.length());
        }
        if (this.isSync()) {
            this.sync();
        }
        return buf.realSize;
    }

    private int bufferedWrite(int c) throws IOException, BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWritable();
        this.ensureWrite();
        if (!this.buffer.hasRemaining()) {
            this.flushWrite();
        }
        this.buffer.put((byte)c);
        if (this.isSync()) {
            this.sync();
        }
        return 1;
    }

    public synchronized void ftruncate(long newLength) throws IOException, BadDescriptorException, InvalidValueException {
        Channel ch = this.descriptor.getChannel();
        if (!(ch instanceof FileChannel)) {
            throw new InvalidValueException();
        }
        this.invalidateBuffer();
        FileChannel fileChannel = (FileChannel)ch;
        if (newLength > fileChannel.size()) {
            long position = fileChannel.position();
            int difference = (int)(newLength - fileChannel.size());
            fileChannel.position(fileChannel.size());
            fileChannel.write(ByteBuffer.allocate(difference));
            fileChannel.position(position);
        } else {
            fileChannel.truncate(newLength);
        }
    }

    private void invalidateBuffer() throws IOException, BadDescriptorException {
        if (!this.reading) {
            this.flushWrite();
        }
        int posOverrun = this.buffer.remaining();
        this.buffer.clear();
        if (this.reading) {
            this.buffer.flip();
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            if (posOverrun != 0) {
                fileChannel.position(fileChannel.position() - (long)posOverrun);
            }
        }
    }

    public synchronized void finalize() {
        if (this.closedExplicitly) {
            return;
        }
        if (this.descriptor != null && this.descriptor.isSeekable() && this.descriptor.isOpen()) {
            this.closeForFinalize();
        }
    }

    public int ready() throws IOException {
        return this.newInputStream().available();
    }

    public synchronized void fputc(int c) throws IOException, BadDescriptorException {
        try {
            this.bufferedWrite(c);
            this.fflush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int ungetc(int c) {
        if (c == -1) {
            return -1;
        }
        this.eof = false;
        this.ungotc = c;
        return c;
    }

    public synchronized int fgetc() throws IOException, BadDescriptorException {
        if (this.eof) {
            return -1;
        }
        this.checkReadable();
        int c = this.read();
        if (c == -1) {
            this.eof = true;
            return c;
        }
        return c & 0xFF;
    }

    public synchronized int fwrite(ByteList string) throws IOException, BadDescriptorException {
        return this.bufferedWrite(string);
    }

    public synchronized ByteList fread(int number) throws IOException, BadDescriptorException {
        try {
            if (number == 0) {
                if (this.eof) {
                    return null;
                }
                return new ByteList(0);
            }
            if (this.ungotc >= 0) {
                ByteList buf2 = this.bufferedRead(number - 1);
                buf2.prepend((byte)this.ungotc);
                this.ungotc = -1;
                return buf2;
            }
            return this.bufferedRead(number);
        }
        catch (EOFException e) {
            this.eof = true;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ByteList readnonblock(int number) throws IOException, BadDescriptorException, EOFException {
        assert (number >= 0);
        if (number == 0) {
            return null;
        }
        if (this.descriptor.getChannel() instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)this.descriptor.getChannel();
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                ByteList byteList;
                boolean oldBlocking = selectableChannel.isBlocking();
                try {
                    selectableChannel.configureBlocking(false);
                    byteList = this.readpartial(number);
                }
                catch (Throwable throwable) {
                    selectableChannel.configureBlocking(oldBlocking);
                    throw throwable;
                }
                selectableChannel.configureBlocking(oldBlocking);
                return byteList;
            }
        }
        return null;
    }

    public synchronized ByteList readpartial(int number) throws IOException, BadDescriptorException, EOFException {
        assert (number >= 0);
        if (number == 0) {
            return null;
        }
        if (this.descriptor.getChannel() instanceof SelectableChannel) {
            if (!(this.ungotc < 0 || --number != 0 && this.buffer.hasRemaining())) {
                ByteList result = new ByteList(new byte[]{(byte)this.ungotc}, false);
                this.ungotc = -1;
                return result;
            }
            if (this.buffer.hasRemaining()) {
                ByteList result = this.bufferedRead(Math.min(this.buffer.remaining(), number));
                if (this.ungotc >= 0) {
                    result.prepend((byte)this.ungotc);
                    this.ungotc = -1;
                }
                return result;
            }
            return this.read(number);
        }
        return null;
    }

    public synchronized int read() throws IOException, BadDescriptorException {
        try {
            this.descriptor.checkOpen();
            if (this.ungotc >= 0) {
                int c = this.ungotc;
                this.ungotc = -1;
                return c;
            }
            return this.bufferedRead();
        }
        catch (EOFException e) {
            this.eof = true;
            return -1;
        }
    }

    public ChannelDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlocking(boolean block) throws IOException {
        if (!(this.descriptor.getChannel() instanceof SelectableChannel)) {
            return;
        }
        Object object = ((SelectableChannel)this.descriptor.getChannel()).blockingLock();
        synchronized (object) {
            this.blocking = block;
            try {
                ((SelectableChannel)this.descriptor.getChannel()).configureBlocking(block);
            }
            catch (IllegalBlockingModeException illegalBlockingModeException) {
                // empty catch block
            }
        }
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public synchronized void freopen(String path, ModeFlags modes) throws DirectoryAsFileException, IOException, InvalidValueException, PipeException, BadDescriptorException {
        this.flushWrite();
        this.buffer.clear();
        if (this.reading) {
            this.buffer.flip();
        }
        this.modes = modes;
        if (this.descriptor.isOpen()) {
            this.descriptor.close();
        }
        if (path.equals("/dev/null") || path.equalsIgnoreCase("nul:") || path.equalsIgnoreCase("nul")) {
            this.descriptor = new ChannelDescriptor(new NullChannel(), this.descriptor.getFileno(), modes, new FileDescriptor());
        } else {
            String cwd = this.getRuntime().getCurrentDirectory();
            JRubyFile theFile = JRubyFile.create(cwd, path);
            if (theFile.isDirectory() && modes.isWritable()) {
                throw new DirectoryAsFileException();
            }
            if (modes.isCreate()) {
                if (theFile.exists() && modes.isExclusive()) {
                    throw this.getRuntime().newErrnoEEXISTError("File exists - " + path);
                }
                theFile.createNewFile();
            } else if (!theFile.exists()) {
                throw this.getRuntime().newErrnoENOENTError("file not found - " + path);
            }
            RandomAccessFile file = new RandomAccessFile(theFile, modes.toJavaModeString());
            if (modes.isTruncate()) {
                file.setLength(0L);
            }
            this.descriptor = new ChannelDescriptor(file.getChannel(), this.descriptor.getFileno(), modes, file.getFD());
            if (modes.isAppendable()) {
                this.lseek(0L, 2);
            }
        }
    }

    public static Stream fopen(Ruby runtime, String path, ModeFlags modes) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException, InvalidValueException, PipeException, BadDescriptorException {
        String cwd = runtime.getCurrentDirectory();
        ChannelDescriptor descriptor = ChannelDescriptor.open(cwd, path, modes);
        Stream stream = ChannelStream.fdopen(runtime, descriptor, modes);
        if (modes.isAppendable()) {
            stream.lseek(0L, 2);
        }
        return stream;
    }

    public static Stream fdopen(Ruby runtime, ChannelDescriptor descriptor, ModeFlags modes) throws InvalidValueException {
        ChannelStream handler = new ChannelStream(runtime, descriptor, modes, descriptor.getFileDescriptor());
        return handler;
    }
}

