/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.validation.util;

import net.sourceforge.wife.validation.util.ISOCountries;

public class BIC {
    private String invalidCause = null;
    private String bic;

    public BIC(String bic) {
        this.bic = bic;
    }

    public BIC() {
    }

    public String getBic() {
        return this.bic;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public String getInvalidCause() {
        return this.invalidCause;
    }

    public boolean isValid() {
        if (this.bic == null) {
            throw new IllegalStateException("bic is null");
        }
        this.invalidCause = null;
        if (this.bic.length() != 8 && this.bic.length() != 11) {
            this.invalidCause = "BIC must be 8 or 11 chars, got " + this.bic.length();
            return false;
        }
        String country = this.bic.substring(4, 6);
        if (!ISOCountries.getInstance().isValidCode(country.toUpperCase())) {
            this.invalidCause = "Invalid country code: " + country;
            return false;
        }
        return true;
    }
}

