/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.swift.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.wife.swift.model.SwiftBlock;
import net.sourceforge.wife.swift.model.Tag;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class SwiftTagListBlock
extends SwiftBlock
implements Serializable {
    private static final transient Logger log = Logger.getLogger(SwiftTagListBlock.class.getName());
    protected List tags = new ArrayList();

    protected SwiftTagListBlock() {
    }

    public boolean containsTag(String tagName) {
        Validate.notNull((Object)tagName, (String)"parameter 'tagName' cannot not be null");
        Iterator it = this.tags.iterator();
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            if (t.getName() == null || !t.getName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public String getTagValue(String key) {
        Validate.notNull((Object)key, (String)"parameter 'key' cannot not be null");
        Tag tag = this.getTagByName(key);
        return tag != null ? tag.getValue() : null;
    }

    public Tag getTagByName(String key) {
        Validate.notNull((Object)key, (String)"parameter 'key' cannot not be null");
        Iterator it = this.tags.iterator();
        while (it.hasNext()) {
            Tag f = (Tag)it.next();
            if (!f.getName().equals(key)) continue;
            return f;
        }
        return null;
    }

    public List getTags() {
        return this.tags;
    }

    public void addTag(Tag t) {
        Validate.notNull((Object)t, (String)"parameter 't' cannot not be null");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding Tag [" + t + "]");
        }
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        this.tags.add(t);
    }

    public int getTagCount(String key) {
        Validate.notNull((Object)key, (String)"parameter 'key' cannot not be null");
        int count = 0;
        if (this.tags != null) {
            Iterator it = this.tags.iterator();
            while (it.hasNext()) {
                Tag f = (Tag)it.next();
                if (!f.getName().equals(key)) continue;
                ++count;
            }
        }
        return count;
    }

    public String[] getTagValues(String key) {
        Validate.notNull((Object)key, (String)"parameter 'key' cannot not be null");
        ArrayList<String> ret = new ArrayList<String>();
        if (this.tags != null) {
            Iterator it = this.tags.iterator();
            while (it.hasNext()) {
                Tag f = (Tag)it.next();
                if (!f.getName().equals(key)) continue;
                ret.add(f.getValue());
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public Map getTagMap() {
        if (this.tags != null) {
            HashMap<String, String> m = new HashMap<String, String>(this.tags.size());
            Iterator it = this.tags.iterator();
            while (it.hasNext()) {
                Tag f = (Tag)it.next();
                if (m.containsKey(f.getName())) continue;
                m.put(f.getName(), f.getValue());
            }
            return m;
        }
        return null;
    }

    public String removeTag(String tag) {
        Validate.notNull((Object)tag, (String)"parameter 'tag' cannot not be null");
        if (this.tags != null) {
            int i = 0;
            Iterator it = this.tags.iterator();
            while (it.hasNext()) {
                Tag t = (Tag)it.next();
                if (t.getName() != null && t.getName().equals(tag)) {
                    this.tags.remove(i);
                    return t.getValue();
                }
                ++i;
            }
        }
        return null;
    }

    public int removeAll(String name) {
        Validate.notNull((Object)name, (String)"parameter 'name' cannot not be null");
        int removed = 0;
        Tag[] matching = this.getTagsByName(name);
        for (int i = 0; i < matching.length; ++i) {
            this.tags.remove(matching[i]);
            ++removed;
        }
        return removed;
    }

    public Tag[] getTagsByName(String name) {
        Validate.notNull((Object)name, (String)"parameter 'name' cannot not be null");
        ArrayList<Tag> l = new ArrayList<Tag>();
        Iterator it = this.tags.iterator();
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            if (t.getName() == null && name == null) {
                l.add(t);
            }
            if (t.getName() == null || name == null || !t.getName().equals(name)) continue;
            l.add(t);
        }
        return l.toArray(new Tag[l.size()]);
    }

    public Iterator tagIterator() {
        if (this.tags == null || this.tags.isEmpty()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No tags in block, returning empty iterator");
            }
            return new EmptyItr();
        }
        return this.tags.iterator();
    }

    public Tag getTag(int i) {
        return (Tag)this.tags.get(i);
    }

    public void addTags(List tags) {
        Validate.notNull((Object)tags, (String)"parameter 'tags' cannot not be null");
        Validate.allElementsOfType((Collection)tags, (Class)Tag.class, (String)"parameter 'tags' may only have Tag elements");
        this.tags.addAll(tags);
    }

    public int getTagCount() {
        return this.tags == null ? 0 : this.tags.size();
    }

    public void setTags(List tags) {
        if (tags != null) {
            Validate.allElementsOfType((Collection)tags, (Class)Tag.class, (String)"parameter 'tags' may only have Tag elements");
        }
        this.tags = tags;
    }

    public boolean isEmpty() {
        return this.tags == null || this.tags.isEmpty();
    }

    public boolean containsBlockData() {
        return false;
    }

    public int size() {
        return this.tags == null ? 0 : this.tags.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.tags == null ? 0 : ((Object)this.tags).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwiftTagListBlock other = (SwiftTagListBlock)obj;
        return !(this.tags == null ? other.tags != null : !((Object)this.tags).equals(other.tags));
    }

    private static final class EmptyItr
    implements Iterator {
        private EmptyItr() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove on an empty iterator");
        }
    }
}

