/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.client;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;

public abstract class SecurityClient {
    protected Object userPrincipal = null;
    protected Object credential = null;
    protected CallbackHandler callbackHandler = null;
    protected String loginConfigName = null;
    protected String saslMechanism = null;
    protected String saslAuthorizationId = null;
    protected boolean jaasDesired = false;
    protected boolean saslDesired = false;

    public void login() throws LoginException {
        if (this.jaasDesired) {
            this.performJAASLogin();
        } else if (this.saslDesired) {
            this.peformSASLLogin();
        } else {
            this.performSimpleLogin();
        }
    }

    public void logout() {
        this.setSimple(null, null);
        this.setJAAS(null, null);
        this.setSASL(null, null, null);
        this.cleanUp();
    }

    public void setSimple(Object username, Object credential) {
        this.userPrincipal = username;
        this.credential = credential;
    }

    public void setJAAS(String configName, CallbackHandler cbh) {
        this.loginConfigName = configName;
        this.callbackHandler = cbh;
        this.clearUpDesires();
        this.jaasDesired = true;
    }

    public void setSASL(String mechanism, String authorizationId, CallbackHandler cbh) {
        this.saslMechanism = mechanism;
        this.saslAuthorizationId = authorizationId;
        this.callbackHandler = cbh;
        this.clearUpDesires();
        this.saslDesired = true;
    }

    protected abstract void performJAASLogin() throws LoginException;

    protected abstract void peformSASLLogin();

    protected abstract void performSimpleLogin();

    protected abstract void cleanUp();

    private void clearUpDesires() {
        this.jaasDesired = false;
        this.saslDesired = false;
    }
}

