/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SynchronousQueue
extends AbstractQueue
implements BlockingQueue,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    private final ReentrantLock qlock;
    private final WaitQueue waitingProducers;
    private final WaitQueue waitingConsumers;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void unlinkCancelledConsumer(Node node) {
        if (!this.waitingConsumers.shouldUnlink(node)) return;
        this.qlock.lock();
        try {
            if (this.waitingConsumers.shouldUnlink(node)) {
                this.waitingConsumers.unlink(node);
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.qlock.unlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.qlock.unlock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void unlinkCancelledProducer(Node node) {
        if (!this.waitingProducers.shouldUnlink(node)) return;
        this.qlock.lock();
        try {
            if (this.waitingProducers.shouldUnlink(node)) {
                this.waitingProducers.unlink(node);
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.qlock.unlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.qlock.unlock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(Object e) throws InterruptedException {
        Node node;
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock qlock = this.qlock;
        do {
            Object var6_5;
            boolean mustWait;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            qlock.lock();
            try {
                node = this.waitingConsumers.deq();
                boolean bl = false;
                if (node == null) {
                    bl = mustWait = true;
                }
                if (bl) {
                    node = this.waitingProducers.enq(e);
                }
            }
            catch (Throwable throwable) {
                var6_5 = null;
                qlock.unlock();
                throw throwable;
            }
            {
                var6_5 = null;
                qlock.unlock();
                if (!mustWait) continue;
            }
            try {
                node.waitForTake();
                return;
            }
            catch (InterruptedException ex) {
                this.unlinkCancelledProducer(node);
                throw ex;
            }
        } while (!node.setItem(e));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean offer(Object e, long timeout, TimeUnit unit) throws InterruptedException {
        Node node;
        if (e == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        ReentrantLock qlock = this.qlock;
        do {
            Object var11_8;
            boolean mustWait;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            qlock.lock();
            try {
                node = this.waitingConsumers.deq();
                boolean bl = false;
                if (node == null) {
                    bl = mustWait = true;
                }
                if (bl) {
                    node = this.waitingProducers.enq(e);
                }
            }
            catch (Throwable throwable) {
                var11_8 = null;
                qlock.unlock();
                throw throwable;
            }
            {
                var11_8 = null;
                qlock.unlock();
                if (!mustWait) continue;
            }
            try {
                boolean x = node.waitForTake(nanos);
                if (!x) {
                    this.unlinkCancelledProducer(node);
                }
                return x;
            }
            catch (InterruptedException ex) {
                this.unlinkCancelledProducer(node);
                throw ex;
            }
        } while (!node.setItem(e));
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object take() throws InterruptedException {
        Node node;
        Object x;
        ReentrantLock qlock = this.qlock;
        do {
            Object var5_4;
            boolean mustWait;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            qlock.lock();
            try {
                node = this.waitingProducers.deq();
                boolean bl = false;
                if (node == null) {
                    bl = mustWait = true;
                }
                if (bl) {
                    node = this.waitingConsumers.enq(null);
                }
            }
            catch (Throwable throwable) {
                var5_4 = null;
                qlock.unlock();
                throw throwable;
            }
            {
                var5_4 = null;
                qlock.unlock();
                if (!mustWait) continue;
            }
            try {
                return node.waitForPut();
            }
            catch (InterruptedException ex) {
                this.unlinkCancelledConsumer(node);
                throw ex;
            }
        } while ((x = node.getItem()) == null);
        return x;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        Node node;
        Object x;
        long nanos = unit.toNanos(timeout);
        ReentrantLock qlock = this.qlock;
        do {
            Object var10_7;
            boolean mustWait;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            qlock.lock();
            try {
                node = this.waitingProducers.deq();
                boolean bl = false;
                if (node == null) {
                    bl = mustWait = true;
                }
                if (bl) {
                    node = this.waitingConsumers.enq(null);
                }
            }
            catch (Throwable throwable) {
                var10_7 = null;
                qlock.unlock();
                throw throwable;
            }
            {
                var10_7 = null;
                qlock.unlock();
                if (!mustWait) continue;
            }
            try {
                x = node.waitForPut(nanos);
                if (x == null) {
                    this.unlinkCancelledConsumer(node);
                }
                return x;
            }
            catch (InterruptedException ex) {
                this.unlinkCancelledConsumer(node);
                throw ex;
            }
        } while ((x = node.getItem()) == null);
        return x;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean offer(Object e) {
        Node node;
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock qlock = this.qlock;
        do {
            Object var5_4;
            qlock.lock();
            try {
                node = this.waitingConsumers.deq();
                var5_4 = null;
                qlock.unlock();
                if (node == null) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                var5_4 = null;
                qlock.unlock();
                throw throwable;
            }
        } while (!node.setItem(e));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object poll() {
        Node node;
        Object x;
        ReentrantLock qlock = this.qlock;
        do {
            Object var4_3;
            qlock.lock();
            try {
                node = this.waitingProducers.deq();
                var4_3 = null;
                qlock.unlock();
                if (node == null) {
                    return null;
                }
            }
            catch (Throwable throwable) {
                var4_3 = null;
                qlock.unlock();
                throw throwable;
            }
        } while ((x = node.getItem()) == null);
        return x;
    }

    public boolean isEmpty() {
        return true;
    }

    public int size() {
        return 0;
    }

    public int remainingCapacity() {
        return 0;
    }

    public void clear() {
    }

    public boolean contains(Object o) {
        return false;
    }

    public boolean remove(Object o) {
        return false;
    }

    public boolean containsAll(Collection c) {
        return c.isEmpty();
    }

    public boolean removeAll(Collection c) {
        return false;
    }

    public boolean retainAll(Collection c) {
        return false;
    }

    public Object peek() {
        return null;
    }

    public Iterator iterator() {
        return new EmptyIterator();
    }

    public Object[] toArray() {
        return new Object[0];
    }

    public Object[] toArray(Object[] a) {
        if (a.length > 0) {
            a[0] = null;
        }
        return a;
    }

    public int drainTo(Collection c) {
        Object e;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((e = this.poll()) != null) {
            c.add(e);
            ++n;
        }
        return n;
    }

    public int drainTo(Collection c, int maxElements) {
        Object e;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < maxElements && (e = this.poll()) != null) {
            c.add(e);
            ++n;
        }
        return n;
    }

    public SynchronousQueue() {
        this(false);
    }

    public SynchronousQueue(boolean fair) {
        if (fair) {
            this.qlock = new ReentrantLock(true);
            this.waitingProducers = new FifoWaitQueue();
            this.waitingConsumers = new FifoWaitQueue();
        } else {
            this.qlock = new ReentrantLock();
            this.waitingProducers = new LifoWaitQueue();
            this.waitingConsumers = new LifoWaitQueue();
        }
    }

    static abstract class WaitQueue
    implements Serializable {
        abstract Node enq(Object var1);

        abstract Node deq();

        abstract void unlink(Node var1);

        abstract boolean shouldUnlink(Node var1);

        WaitQueue() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static final class Node
    implements Serializable {
        private static final long serialVersionUID = -3223113410248163686L;
        private static final int ACK = 1;
        private static final int CANCEL = -1;
        int state;
        Object item;
        Node next;

        private final Object extract() {
            Object x = this.item;
            this.item = null;
            return x;
        }

        private final void checkCancellationOnInterrupt(InterruptedException ie) throws InterruptedException {
            if (this.state == 0) {
                this.state = -1;
                this.notify();
                throw ie;
            }
            Thread.currentThread().interrupt();
        }

        final synchronized boolean setItem(Object x) {
            if (this.state != 0) {
                return false;
            }
            this.item = x;
            this.state = 1;
            this.notify();
            return true;
        }

        final synchronized Object getItem() {
            if (this.state != 0) {
                return null;
            }
            this.state = 1;
            this.notify();
            return this.extract();
        }

        final synchronized void waitForTake() throws InterruptedException {
            try {
                while (this.state == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                this.checkCancellationOnInterrupt(ie);
            }
        }

        final synchronized Object waitForPut() throws InterruptedException {
            try {
                while (this.state == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                this.checkCancellationOnInterrupt(ie);
            }
            return this.extract();
        }

        private final boolean attempt(long nanos) throws InterruptedException {
            if (this.state != 0) {
                return true;
            }
            if (nanos <= 0L) {
                this.state = -1;
                this.notify();
                return false;
            }
            long deadline = Utils.nanoTime() + nanos;
            do {
                TimeUnit.NANOSECONDS.timedWait(this, nanos);
                if (this.state == 0) continue;
                return true;
            } while ((nanos = deadline - Utils.nanoTime()) > 0L);
            this.state = -1;
            this.notify();
            return false;
        }

        final synchronized boolean waitForTake(long nanos) throws InterruptedException {
            try {
                if (!this.attempt(nanos)) {
                    return false;
                }
            }
            catch (InterruptedException ie) {
                this.checkCancellationOnInterrupt(ie);
            }
            return true;
        }

        final synchronized Object waitForPut(long nanos) throws InterruptedException {
            try {
                if (!this.attempt(nanos)) {
                    return null;
                }
            }
            catch (InterruptedException ie) {
                this.checkCancellationOnInterrupt(ie);
            }
            return this.extract();
        }

        private final /* synthetic */ void this() {
            this.state = 0;
        }

        Node(Object x) {
            this.this();
            this.item = x;
        }

        Node(Object x, Node n) {
            this.this();
            this.item = x;
            this.next = n;
        }
    }

    static class EmptyIterator
    implements Iterator {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }

        EmptyIterator() {
        }
    }

    static final class FifoWaitQueue
    extends WaitQueue
    implements Serializable {
        private static final long serialVersionUID = -3623113410248163686L;
        private transient Node head;
        private transient Node last;

        final Node enq(Object x) {
            Node p = new Node(x);
            this.last = this.last == null ? (this.head = p) : (this.last.next = p);
            return p;
        }

        final Node deq() {
            Node p = this.head;
            if (p != null) {
                this.head = p.next;
                if (this.head == null) {
                    this.last = null;
                }
                p.next = null;
            }
            return p;
        }

        final boolean shouldUnlink(Node node) {
            boolean bl = false;
            if (node == this.last || node.next != null) {
                bl = true;
            }
            return bl;
        }

        final void unlink(Node node) {
            Node p = this.head;
            Node trail = null;
            while (p != null) {
                if (p == node) {
                    Node next = p.next;
                    if (trail == null) {
                        this.head = next;
                    } else {
                        trail.next = next;
                    }
                    if (this.last != node) break;
                    this.last = trail;
                    break;
                }
                trail = p;
                p = p.next;
            }
        }

        FifoWaitQueue() {
        }
    }

    static final class LifoWaitQueue
    extends WaitQueue
    implements Serializable {
        private static final long serialVersionUID = -3633113410248163686L;
        private transient Node head;

        final Node enq(Object x) {
            this.head = new Node(x, this.head);
            return this.head;
        }

        final Node deq() {
            Node p = this.head;
            if (p != null) {
                this.head = p.next;
                p.next = null;
            }
            return p;
        }

        final boolean shouldUnlink(Node node) {
            boolean bl = false;
            if (node == this.head || node.next != null) {
                bl = true;
            }
            return bl;
        }

        final void unlink(Node node) {
            Node p = this.head;
            Node trail = null;
            while (p != null) {
                if (p == node) {
                    Node next = p.next;
                    if (trail == null) {
                        this.head = next;
                        break;
                    }
                    trail.next = next;
                    break;
                }
                trail = p;
                p = p.next;
            }
        }

        LifoWaitQueue() {
        }
    }
}

