/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.security.plugins.SubjectActions;

public class TransactionManagerLocator {
    private static Logger log = Logger.getLogger(TransactionManagerLocator.class);

    public TransactionManager getTM(String jndiName) throws NamingException {
        TransactionManager tm = null;
        InitialContext ctx = new InitialContext();
        try {
            tm = (TransactionManager)ctx.lookup(jndiName);
        }
        catch (NameNotFoundException nfe) {
            try {
                tm = this.getJBossTM();
            }
            catch (Exception ignore) {
                log.trace((Object)"Exception in getJBossTM:", (Throwable)ignore);
            }
        }
        return tm;
    }

    private TransactionManager getJBossTM() throws Exception {
        ClassLoader tcl = SubjectActions.getContextClassLoader();
        Class<?> clz = tcl.loadClass("org.jboss.tm.TxManager");
        Method m = clz.getMethod("getInstance", new Class[0]);
        return (TransactionManager)m.invoke(null, new Object[0]);
    }
}

