/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.util.CachePolicy;

public class SecurityDomainContext {
    static final String ACTIVE_SUBJECT = "subject";
    static final String AUTHENTICATION_MGR = "securityMgr";
    static final String REALM_MAPPING = "realmMapping";
    static final String AUTHORIZATION_MGR = "authorizationMgr";
    static final String AUTH_CACHE = "authenticationCache";
    static final String DOMAIN_CONTEXT = "domainContext";
    AuthenticationManager securityMgr;
    AuthorizationManager authorizationMgr;
    CachePolicy authenticationCache;

    public SecurityDomainContext(AuthenticationManager securityMgr, CachePolicy authenticationCache) {
        this.securityMgr = securityMgr;
        this.authenticationCache = authenticationCache;
    }

    public Object lookup(String name) throws NamingException {
        Object binding = null;
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("name cannot be null or empty");
        }
        if (name.equals(ACTIVE_SUBJECT)) {
            binding = this.getSubject();
        } else if (name.equals(AUTHENTICATION_MGR)) {
            binding = this.securityMgr;
        } else if (name.equals(REALM_MAPPING)) {
            binding = this.getRealmMapping();
        } else if (name.equals(AUTHORIZATION_MGR)) {
            binding = this.getAuthorizationManager();
        } else if (name.equals(AUTH_CACHE)) {
            binding = this.authenticationCache;
        } else if (name.equals(DOMAIN_CONTEXT)) {
            binding = this;
        }
        return binding;
    }

    public Subject getSubject() {
        Subject subject = null;
        if (this.securityMgr instanceof SubjectSecurityManager) {
            subject = ((SubjectSecurityManager)this.securityMgr).getActiveSubject();
        }
        return subject;
    }

    public AuthenticationManager getSecurityManager() {
        return this.securityMgr;
    }

    public RealmMapping getRealmMapping() {
        RealmMapping realmMapping = null;
        if (this.authorizationMgr != null && this.authorizationMgr instanceof RealmMapping) {
            realmMapping = (RealmMapping)this.authorizationMgr;
        } else if (this.securityMgr instanceof RealmMapping) {
            realmMapping = (RealmMapping)this.securityMgr;
        }
        return realmMapping;
    }

    public void setAuthorizationManager(AuthorizationManager am) {
        this.authorizationMgr = am;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationMgr;
    }

    public CachePolicy getAuthenticationCache() {
        return this.authenticationCache;
    }
}

