/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SecurityIdentity;
import org.jboss.security.SubjectInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSecurityContextUtil
extends SecurityContextUtil {
    public JBossSecurityContextUtil(SecurityContext sc) {
        this.securityContext = sc;
    }

    public <T> T get(String key) {
        this.validateSecurityContext();
        if ("RunAsIdentity".equals(key)) {
            return (T)this.securityContext.getRunAs();
        }
        return (T)this.securityContext.getData().get(key);
    }

    public String getUserName() {
        Principal p = this.getUserPrincipal();
        return p != null ? p.getName() : null;
    }

    public Principal getUserPrincipal() {
        this.validateSecurityContext();
        Principal p = null;
        SubjectInfo subjectInfo = this.securityContext.getSubjectInfo();
        if (subjectInfo != null) {
            p = subjectInfo.getAuthenticationPrincipal();
        }
        return p;
    }

    public Object getCredential() {
        this.validateSecurityContext();
        Object cred = null;
        SubjectInfo subjectInfo = this.securityContext.getSubjectInfo();
        if (subjectInfo != null) {
            cred = subjectInfo.getAuthenticationCredential();
        }
        return cred;
    }

    public Subject getSubject() {
        this.validateSecurityContext();
        Subject s = null;
        SubjectInfo subjectInfo = this.securityContext.getSubjectInfo();
        if (subjectInfo != null) {
            s = subjectInfo.getAuthenticatedSubject();
        }
        return s;
    }

    public <T> void set(String key, T obj) {
        this.validateSecurityContext();
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (obj != null) {
            if ("RunAsIdentity".equals(key) && !(obj instanceof RunAsIdentity)) {
                throw new IllegalArgumentException("Not RunAsIdentity:" + obj);
            }
            if ("Roles".equals(key) && !(obj instanceof Group)) {
                throw new IllegalArgumentException("Not Group:" + obj);
            }
        }
        if ("RunAsIdentity".equals(key)) {
            this.setRunAsIdentity((RunAsIdentity)obj);
        } else {
            this.securityContext.getData().put(key, obj);
        }
    }

    public <T> T remove(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        Map contextMap = this.securityContext.getData();
        if ("RunAsIdentity".equals(key)) {
            RunAs runAs = this.securityContext.getRunAs();
            this.securityContext.setRunAs((RunAs)contextMap.get("CallerRunAsIdentity"));
            contextMap.remove("CallerRunAsIdentity");
            return (T)runAs;
        }
        return (T)contextMap.remove(key);
    }

    public RunAs getCallerRunAs() {
        this.validateSecurityContext();
        return (RunAs)this.securityContext.getData().get("CallerRunAsIdentity");
    }

    public void setCallerRunAs(RunAs runAs) {
        this.validateSecurityContext();
        this.securityContext.getData().put("CallerRunAsIdentity", runAs);
    }

    public <T> void setRoles(T roles) {
        this.validateSecurityContext();
        this.securityContext.getData().put("Roles", roles);
    }

    public void setSecurityIdentity(SecurityIdentity sidentity) {
        this.createSubjectInfo(sidentity.getPrincipal(), sidentity.getCredential(), sidentity.getSubject());
        this.securityContext.setRunAs(sidentity.getRunAs());
        this.setCallerRunAs(sidentity.getCallerRunAs());
    }

    public SecurityIdentity getSecurityIdentity() {
        return new SecurityIdentity(this.securityContext.getSubjectInfo(), this.securityContext.getRunAs(), this.getCallerRunAs());
    }

    private void setRunAsIdentity(RunAsIdentity rai) {
        Map contextMap = this.securityContext.getData();
        RunAs currentRA = this.securityContext.getRunAs();
        contextMap.put("CallerRunAsIdentity", currentRA);
        this.securityContext.setRunAs((RunAs)rai);
    }

    public <T> T getRoles() {
        this.validateSecurityContext();
        return (T)this.securityContext.getData().get("Roles");
    }

    private void validateSecurityContext() {
        if (this.securityContext == null) {
            throw new IllegalStateException("SecurityContext is null: set it on the util");
        }
    }
}

