/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SecurityUtil;
import org.jboss.security.SubjectInfo;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.plugins.SecurityContextFactory;
import org.jboss.security.plugins.audit.JBossAuditManager;
import org.jboss.security.plugins.mapping.JBossMappingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSecurityContext
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = Logger.getLogger(JBossSecurityContext.class);
    protected boolean trace = log.isTraceEnabled();
    protected Map<String, Object> contextData = new HashMap<String, Object>();
    protected String securityDomain = "other";
    protected SubjectInfo subjectInfo = null;
    protected RunAs configuredRunAs = null;

    public JBossSecurityContext(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public AuthenticationManager getAuthenticationManager() {
        return SecurityUtil.getAuthenticationManager(this.securityDomain);
    }

    public AuthorizationManager getAuthorizationManager() {
        return SecurityUtil.getAuthorizationManager(this.securityDomain);
    }

    public Map<String, Object> getData() {
        return this.contextData;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public SubjectInfo getSubjectInfo() {
        return this.subjectInfo;
    }

    public AuditManager getAuditManager() {
        return new JBossAuditManager(this.securityDomain);
    }

    public MappingManager getMappingManager() {
        return new JBossMappingManager(this.securityDomain);
    }

    public RunAs getRunAs() {
        return this.configuredRunAs;
    }

    public void setRunAs(RunAs runAs) {
        this.configuredRunAs = runAs;
    }

    public SecurityContextUtil getUtil() {
        return SecurityContextFactory.createUtil(this);
    }

    public void setSubjectInfo(SubjectInfo si) {
        this.subjectInfo = si;
    }

    public void setRoles(Group roles, boolean replace) {
        Group mergedRoles = roles;
        if (!replace) {
            mergedRoles = this.mergeGroups((Group)this.contextData.get("Roles"), roles);
        }
        this.contextData.put("Roles", mergedRoles);
    }

    private Group mergeGroups(Group a, Group b) {
        Group newGroup = b;
        if (a != null) {
            Enumeration en = a.members();
            while (en.hasMoreElements()) {
                newGroup.addMember((Principal)en.nextElement());
            }
        }
        return newGroup;
    }

    public Object clone() throws CloneNotSupportedException {
        JBossSecurityContext jsc = (JBossSecurityContext)super.clone();
        if (jsc != null) {
            jsc.contextData = (Map)((HashMap)this.contextData).clone();
        }
        return super.clone();
    }
}

