/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.message.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthParam;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import org.jboss.mx.util.MBeanServerLocator;

public class JBossServerAuthConfig
implements ServerAuthConfig {
    private String layer;
    private String contextId;
    private CallbackHandler callbackHandler;
    private List modules = new ArrayList();
    private Map contextProperties;

    public JBossServerAuthConfig(String layer, String appContext, CallbackHandler handler, Map properties) {
        this.layer = layer;
        this.contextId = appContext;
        this.callbackHandler = handler;
        this.contextProperties = properties;
    }

    public ServerAuthContext getAuthContext(String operation, Map properties) throws AuthException {
        MBeanServer server = MBeanServerLocator.locateJBoss();
        ServerAuthContext sc = null;
        if (this.layer.equals("HttpServlet")) {
            try {
                ObjectName oname = new ObjectName("jboss.security:service=JASPISecurityManager");
                String securityDomain = (String)server.invoke(oname, "getSecurityDomain", new Object[]{this.contextId}, new String[]{"java.lang.String"});
                sc = (ServerAuthContext)server.invoke(oname, "getSecurityManager", new Object[]{securityDomain}, new String[]{"java.lang.String"});
            }
            catch (JMException jme) {
                throw new AuthException(jme.toString());
            }
        }
        return sc;
    }

    public String getContextID() {
        return this.contextId;
    }

    public String getMessageLayer() {
        return this.layer;
    }

    public String getOperation(AuthParam authParam) {
        return null;
    }

    public void refresh() throws AuthException, SecurityException {
    }

    public List getServerAuthModules() {
        return this.modules;
    }
}

