/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.message.config;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ServerAuthConfig;
import org.jboss.logging.Logger;
import org.jboss.security.auth.message.config.JBossClientAuthConfig;
import org.jboss.security.auth.message.config.JBossServerAuthConfig;

public class JBossAuthConfigProvider
implements AuthConfigProvider {
    private static Logger log = Logger.getLogger(JBossAuthConfigProvider.class);
    private Map contextProperties = null;
    private String cbhProperty = "authconfigprovider.client.callbackhandler";

    public JBossAuthConfigProvider(Map props) {
        this.contextProperties = props;
    }

    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        if (handler == null) {
            try {
                handler = this.instantiateCallbackHandler();
            }
            catch (Exception e) {
                log.error((Object)"Exception in instantiating callback handler:", (Throwable)e);
                throw new AuthException(e.getMessage());
            }
        }
        return new JBossClientAuthConfig(layer, appContext, handler, this.contextProperties);
    }

    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        if (handler == null) {
            try {
                handler = this.instantiateCallbackHandler();
            }
            catch (Exception e) {
                log.error((Object)"Exception in instantiating callback handler:", (Throwable)e);
                throw new AuthException(e.getMessage());
            }
        }
        return new JBossServerAuthConfig(layer, appContext, handler, this.contextProperties);
    }

    public void refresh() throws AuthException, SecurityException {
    }

    private CallbackHandler instantiateCallbackHandler() throws Exception {
        String cbhClass = System.getProperty(this.cbhProperty);
        if (cbhClass == null) {
            throw new IllegalStateException("CallbackHandler not defined by system property " + this.cbhProperty);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> cls = cl.loadClass(cbhClass);
        return (CallbackHandler)cls.newInstance();
    }
}

