/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.acl.Group;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.SecurityConfiguration;

public class SecurityUtil {
    private static Logger log = Logger.getLogger(SecurityUtil.class);

    public static String unprefixSecurityDomain(String securityDomain) {
        String result = null;
        if (securityDomain != null) {
            result = securityDomain.startsWith("java:/jaas") ? securityDomain.substring("java:/jaas".length() + 1) : (securityDomain.startsWith("java:/jbsx") ? securityDomain.substring("java:/jbsx".length() + 1) : securityDomain);
        }
        return result;
    }

    public static Group getSubjectRoles(Subject theSubject) {
        if (theSubject == null) {
            throw new IllegalArgumentException("Subject is null");
        }
        Set<Group> subjectGroups = theSubject.getPrincipals(Group.class);
        Iterator<Group> iter = subjectGroups.iterator();
        Group roles = null;
        while (iter.hasNext()) {
            Group grp = iter.next();
            String name = grp.getName();
            if (!name.equals("Roles")) continue;
            roles = grp;
        }
        return roles;
    }

    public static ApplicationPolicy getApplicationPolicy(String domainName) {
        return SecurityConfiguration.getApplicationPolicy(domainName);
    }

    public static AuthenticationManager getAuthenticationManager(String securityDomain) {
        AuthenticationManager am;
        block2: {
            String securityMgrURL = "/securityMgr";
            String lookupURL = null;
            lookupURL = securityDomain.startsWith("java:/jaas") ? securityDomain + securityMgrURL : "java:/jaas/" + securityDomain + securityMgrURL;
            am = null;
            try {
                InitialContext ic = new InitialContext();
                am = (AuthenticationManager)ic.lookup(lookupURL);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"Error in obtaining AuthenticationManager", (Throwable)e);
            }
        }
        return am;
    }

    public static AuthorizationManager getAuthorizationManager(String securityDomain) {
        AuthorizationManager am;
        block2: {
            String authorizationMgrURL = "/authorizationMgr";
            String lookupURL = null;
            lookupURL = securityDomain.startsWith("java:/jaas") ? securityDomain + authorizationMgrURL : "java:/jaas/" + securityDomain + authorizationMgrURL;
            am = null;
            try {
                InitialContext ic = new InitialContext();
                am = (AuthorizationManager)ic.lookup(lookupURL);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"Error in obtaining AuthorizationMgr", (Throwable)e);
            }
        }
        return am;
    }
}

