package org.jbpm.gd.jpdl.ui.taskform;

public class Button {
  
  public static final Button BUTTON_SAVE = new Button("<tf:saveButton value=<\"Save\"/>");  
  public static final Button BUTTON_CANCEL = new Button("<tf:cancelButton value=\"Cancel\"/>");

  public static Button createTransitionButton(String transitionName) {
	    return new Button("<tf:transitionButton" + getTo(transitionName) + " value=\"" + getSaveAndClose(transitionName) + "\"/>");
  }
  
  public static String getTo(String transitionName) {
	  return transitionName != null ? " to=\"" + transitionName + "\"" : ""; 
  }
  
  public static String getSaveAndClose(String transitionName) {
	  return transitionName != null ? transitionName : "Save and Close";
  }


  String xhtml;
  
  public Button(String xhtml) {
    this.xhtml = xhtml; 
  }
  
  public String getXhtml() {
    return xhtml;
  }
  
  public void setXhtml(String xhtml) {
    this.xhtml = xhtml;
  }
}
