package org.jbpm.gd.jpdl.ui.properties;

import org.eclipse.jface.viewers.IFilter;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.NamedElement;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.ui.graph.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.jpdl.ui.outline.part.JpdlOutlineEditPart;

public class NamedElementFilter implements IFilter {

	public boolean select(Object toTest) {
		Object input = toTest;
        if (toTest instanceof NotationElementGraphicalEditPart) {
        	AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)toTest).getNotationElement();
        	input = notationElement.getSemanticElement();
        } else if (toTest instanceof JpdlOutlineEditPart) {
        	input = ((JpdlOutlineEditPart)toTest).getModel();
        }
		return input instanceof NamedElement && !(input instanceof ActionElement || input instanceof Task);
	}

}
