package org.jbpm.gd.jpdl.ui.properties;

import org.eclipse.ui.views.properties.tabbed.ITypeMapper;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.ui.graph.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.jpdl.ui.outline.part.JpdlOutlineEditPart;

public class JpdlElementTypeMapper
	implements ITypeMapper {

	public Class mapType(Object object) {
		Class type = object.getClass();
		if (object instanceof NotationElementGraphicalEditPart) {
			Object notationElement = ((NotationElementGraphicalEditPart) object).getModel();		
			type = ((AbstractNotationElement)notationElement).getSemanticElement().getClass();
		} else if (object instanceof JpdlOutlineEditPart) {
			type = ((JpdlOutlineEditPart)object).getModel().getClass();
		}
		return type;
	}
}