package org.jbpm.gd.jpdl.ui.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.model.CancelTimer;
import org.jbpm.gd.jpdl.ui.graph.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.jpdl.ui.outline.part.JpdlOutlineEditPart;


public class CancelTimerSection extends AbstractPropertySection {
	
	private CancelTimerConfigurationComposite cancelTimerConfigurationComposite;
	private CancelTimer cancelTimer;
	
	public void createControls(Composite parent,
            TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite clientArea = getWidgetFactory().createFlatFormComposite(parent);
        cancelTimerConfigurationComposite = CancelTimerConfigurationComposite.create(getWidgetFactory(), clientArea);
    }
 
 	public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) return;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
        	AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
        	input = notationElement.getSemanticElement();
        } else if (input instanceof JpdlOutlineEditPart) {
        	input = ((JpdlOutlineEditPart)input).getModel();
        }
        if (input instanceof CancelTimer) {
        	setCancelTimer((CancelTimer)input);
        }
    }
 	
 	private void setCancelTimer(CancelTimer cancelTimer) {
 		this.cancelTimer = cancelTimer;
 	}

 	public void refresh() {
 		if (cancelTimer != null) {
 			cancelTimerConfigurationComposite.setCancelTimer(cancelTimer);
 		}
    }
 	
	public boolean shouldUseExtraSpace() {
		return true;
	}
	
}