package org.jbpm.gd.jpdl.ui.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.ActionElementContainer;
import org.jbpm.gd.jpdl.model.CancelTimer;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.Mail;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.ui.JpdlLabelProvider;
import org.jbpm.gd.jpdl.ui.graph.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.jpdl.ui.outline.part.JpdlOutlineEditPart;


public class ActionElementContainerSection extends AbstractPropertySection implements PropertyChangeListener {
	
    private TabbedPropertySheetPage tabbedPropertySheetPage;	
    private ActionElementContainer actionElementContainer;
    private ActionElement selectedActionElement;
    private ActionElementContainerSectionActionBarContributor actionBarContributor;
    
    private Table actionElementTable;
    private ScrolledPageBook detailsArea;
    private ActionConfigurationComposite actionConfigurationComposite;
    private ScriptConfigurationComposite scriptConfigurationComposite;
    private CreateTimerConfigurationComposite createTimerConfigurationComposite;
    private CancelTimerConfigurationComposite cancelTimerConfigurationComposite;
    private MailConfigurationComposite mailConfigurationComposite;
	 	
	public void createControls(Composite parent,
			TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);	
		actionBarContributor = new ActionElementContainerSectionActionBarContributor(this);
		tabbedPropertySheetPage = aTabbedPropertySheetPage;
		final Composite composite = getWidgetFactory().createFlatFormComposite(parent);		
		createMasterArea(composite);
		createDetailsArea(composite);
	}
	
	private void createMasterArea(Composite composite) {
		actionElementTable = getWidgetFactory().createTable(
				composite, SWT.SINGLE | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
		actionElementTable.setLayoutData(createActionElementTableLayoutData());
		actionElementTable.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleActionTableSelected();
			}			
		});
		actionBarContributor.createPopupMenu(actionElementTable);
	}
	
	private void createDetailsArea(Composite composite) {
		detailsArea = getWidgetFactory().createPageBook(composite, SWT.V_SCROLL);
		detailsArea.setLayoutData(createDetailsAreaLayoutData());
		createActionPage();
		createScriptPage();
		createCreateTimerPage();
		createCancelTimerPage();
		createMailPage();
	}
	
	private void createActionPage() {
		Composite actionPage = detailsArea.createPage("org.jbpm.gd.jpdl.core.action");
		actionPage.setLayout(new FormLayout());
		actionConfigurationComposite = ActionConfigurationComposite.create(getWidgetFactory(), actionPage);
	}
	
	private void createScriptPage() {
		Composite scriptPage = detailsArea.createPage("org.jbpm.gd.jpdl.core.script");
		scriptPage.setLayout(new FormLayout());
		scriptConfigurationComposite = ScriptConfigurationComposite.create(getWidgetFactory(), scriptPage);
	}
	
	private void createCreateTimerPage() {
		Composite createTimerPage = detailsArea.createPage("org.jbpm.gd.jpdl.core.createTimer");
		createTimerPage.setLayout(new FormLayout());
		createTimerConfigurationComposite = CreateTimerConfigurationComposite.create(getWidgetFactory(), createTimerPage);
	}
	
	private void createCancelTimerPage() {
		Composite cancelTimerPage = detailsArea.createPage("org.jbpm.gd.jpdl.core.cancelTimer");
		cancelTimerPage.setLayout(new FormLayout());
		cancelTimerConfigurationComposite = CancelTimerConfigurationComposite.create(getWidgetFactory(), cancelTimerPage);
	}
	
	private void createMailPage() {
		Composite mailPage = detailsArea.createPage("org.jbpm.gd.jpdl.core.mail");
		mailPage.setLayout(new FormLayout());
		mailConfigurationComposite = MailConfigurationComposite.create(getWidgetFactory(), mailPage);
	}
	
	private void handleActionTableSelected() {
		TableItem[] selectedItems = actionElementTable.getSelection();
		if (selectedItems.length == 0) {
			unSelectAll();
		} else {
			selectActionElement((ActionElement)selectedItems[0].getData());
		}
		updateDetailsArea();
	}
	
	private void updateDetailsArea() {
		if (selectedActionElement != null) {
			detailsArea.showPage(getSelectedActionElement().getElementId());
		} 
	}
	
	
 	private void clearControls() {
		actionElementTable.removeAll();
 		detailsArea.showEmptyPage();
 	}
 	
	private void selectActionElement(ActionElement actionElement) {
		if (actionElement == getSelectedActionElement()) return;
		actionBarContributor.setRemoveEnabled(actionElement != null);
		if (selectedActionElement != null) {
			selectedActionElement.removePropertyChangeListener(this);
		}
		selectedActionElement = actionElement;
		updateActionElementDetails();
		if (actionElement != null) {
			actionElement.addPropertyChangeListener(this);
		}
	}
	
	private void updateActionElementDetails() {
		if (selectedActionElement instanceof Action) {
			actionConfigurationComposite.setAction((Action)selectedActionElement);
		} else if (selectedActionElement instanceof Script) {
			scriptConfigurationComposite.setScript((Script)selectedActionElement);
		} else if (selectedActionElement instanceof CreateTimer) {
			createTimerConfigurationComposite.setCreateTimer((CreateTimer)selectedActionElement);
		} else if (selectedActionElement instanceof CancelTimer) {
			cancelTimerConfigurationComposite.setCancelTimer((CancelTimer)selectedActionElement);
		} else if (selectedActionElement instanceof Mail) {
			mailConfigurationComposite.setMail((Mail)selectedActionElement);
		}
	}
	
	private FormData createActionElementTableLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.right = new FormAttachment(20, -5);
		data.top = new FormAttachment(0, 5);
		data.bottom = new FormAttachment(100, -5);
		return data;
	}
	
	private FormData createDetailsAreaLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(actionElementTable, 0);
		data.top = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.bottom = new FormAttachment(100, 0);
		return data;
	}
	
 	public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) return;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
        	AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
        	setActionElementContainer((ActionElementContainer)notationElement.getSemanticElement());
        } else if (input instanceof JpdlOutlineEditPart) {
        	setActionElementContainer((ActionElementContainer)((JpdlOutlineEditPart)input).getModel());
        }
    }
 	
 	private void setActionElementContainer(ActionElementContainer newActionElementContainer) {
 		if (actionElementContainer == newActionElementContainer) return;
 		if (actionElementContainer != null) {
 			actionElementContainer.removePropertyChangeListener(this);
 		}
 		clearControls();
 		actionElementContainer = newActionElementContainer;
 		if (actionElementContainer != null) {
 			updateActionElementTable();
 			actionElementContainer.addPropertyChangeListener(this);
 		} 		
 	}
 	
	private void unSelectAll() {
		if (somethingSelected()) {
			selectActionElement(null);
		}
	}

	private boolean somethingSelected() {
		return getSelectedActionElement() != null;
	}

 	private void updateActionElementTable() {
 		ActionElement[] actionElements = actionElementContainer.getActionElements();
 		for (int i = 0; i < actionElements.length; i++) {
 			TableItem tableItem = new TableItem(actionElementTable, SWT.NULL);
 			tableItem.setText(getLabel(actionElements[i]));
 			tableItem.setData(actionElements[i]);
 			tableItem.setImage(JpdlLabelProvider.getImage(actionElements[i]));
 		}
 	}
 	
 	private String getLabel(ActionElement actionElement) {
 		String name = actionElement.getName();
 		if (name != null && !"".equals(name)) return name;
 		if (actionElement instanceof Action) {
 			String refName = ((Action)actionElement).getRefName();
 			if (refName != null && !"".equals(refName)) {
 				return refName;
 			}
 		} 
 		return JpdlLabelProvider.getLabel(actionElement).toLowerCase();
 	}
 	
	public TabbedPropertySheetPage getTabbedPropertySheetPage() {
		return tabbedPropertySheetPage;
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if (actionElementTable.isDisposed()) return;
		if ("actionElementAdd".equals(evt.getPropertyName())) {
			TableItem tableItem = new TableItem(actionElementTable, SWT.NULL);
			ActionElement actionElement = (ActionElement)evt.getNewValue();
			tableItem.setText(getLabel(actionElement));
			tableItem.setData(actionElement);
			tableItem.setImage(JpdlLabelProvider.getImage(actionElement));
			actionElementTable.setSelection(tableItem);
			actionElementTable.notifyListeners(SWT.Selection, new org.eclipse.swt.widgets.Event());
		} else if ("actionElementRemove".equals(evt.getPropertyName())) {
			TableItem tableItem = getItemToRemove(evt.getOldValue());
			if (tableItem != null) {
				tableItem.dispose();
				actionElementTable.notifyListeners(SWT.Selection, new org.eclipse.swt.widgets.Event());
			}
		} else if ("name".equals(evt.getPropertyName()) || "refName".equals(evt.getPropertyName())) {
			TableItem tableItem = actionElementTable.getSelection()[0];
			tableItem.setText(getLabel((ActionElement)tableItem.getData()));
		}
	}
	
	private TableItem getItemToRemove(Object object) {
		for (int i = 0; i < actionElementTable.getItemCount(); i++) {
			if (actionElementTable.getItem(i).getData() == object)
				return actionElementTable.getItem(i);
		}
		return null;
	}
	
	public boolean shouldUseExtraSpace() {
		return true;
	}
	
	public ActionElement getSelectedActionElement() {
		return selectedActionElement;
	}

	public void aboutToBeShown() {
		actionBarContributor.activateContributions();
	}
	
	public void aboutToBeHidden() {
		actionBarContributor.deactivateContributions();
	}
	
	public ActionElementContainer getActionElementContainer() {
		return actionElementContainer;
	}

}