package org.jbpm.gd.common.notation;

import org.eclipse.draw2d.geometry.Point;

public class Label extends AbstractNotationElement {
	
	String text = "";
    private Point offset = new Point(5, -10);
    
	public void setText(String text) {
		if (text == null) {
			this.text = "";
		} else {
			this.text = text;
		}
	}
	
	public String getText() {
		return text;
	}
	
	public Point getOffset() {
		return offset;
	}
	
	public void setOffset(Point newOffset) {
		Point oldOffset = offset;
		offset = newOffset;
		firePropertyChange("offset", oldOffset, newOffset);
	}

	
}
