package org.jbpm.gd.jpdl.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class JpdlElementFactory {
	
	public static final JpdlElementFactory INSTANCE = new JpdlElementFactory();
	
	private JpdlElementFactory() {}
	
	public AbstractJpdlElement createByName(String elementName) {
		try {
			IConfigurationElement element = JpdlExtensionRegistry.getConfigurationElementByName(elementName);
			if (element == null) return null;
			AbstractJpdlElement result = (AbstractJpdlElement)element.createExecutableExtension("modelClass");
			result.setElementId(element.getNamespaceIdentifier()+ "." + element.getAttribute("id"));
			return result;
		} catch (CoreException e) {
			throw new RuntimeException("Creation of executable extension failed", e);
		}
	}
	
	public AbstractJpdlElement createById(String elementId) {
		try {
			IConfigurationElement element = JpdlExtensionRegistry.getConfigurationElementById(elementId);
			if (element == null) return null;
			AbstractJpdlElement result = (AbstractJpdlElement)element.createExecutableExtension("modelClass");
			result.setElementId(element.getNamespaceIdentifier()+ "." + element.getAttribute("id"));
			return result;
		} catch (CoreException e) {
			throw new RuntimeException("Creation of executable extension failed", e);
		}
	}
	
}
