#############################################################
#
# pidentd
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
PIDENTD_SOURCE:=pidentd.tar.gz
PIDENTD_SITE:=ftp://ftp.gnu.org/gnu/pidentd
PIDENTD_CAT:=zcat
endif

PIDENTD_DIR:=$(BUILD_DIR)/pidentd
PIDENTD_BINARY:=src/identd
PIDENTD_TARGET_BINARY:=usr/sbin/pidentd

ifneq ($(USE_CVS),true)
pidentd-fetch:
	 $(WGET) -P $(DL_DIR) $(PIDENTD_SITE)/$(PIDENTD_SOURCE)

pidentd-source: $(DL_DIR)/$(PIDENTD_SOURCE)
else
pidentd-source:
endif

PIDENTD_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d pidentd $(CVS_TAG) $(CVS_PREFIX)pidentd

pidentd-checkout:
	@$(PIDENTD_CVSCO)

$(PIDENTD_DIR)/.unpacked: $(DL_DIR)/$(PIDENTD_SOURCE)
ifneq ($(USE_CVS),true)
	$(PIDENTD_CAT) $(DL_DIR)/$(PIDENTD_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PIDENTD_CVSCO)
endif
	cat $(SOURCE_DIR)/pidentd-cross.patch | patch -d $(PIDENTD_DIR) -p0
	cp $(SOURCE_DIR)/config.sub $(PIDENTD_DIR)/aux/
	touch $(PIDENTD_DIR)/.unpacked

$(PIDENTD_DIR)/.configured: $(PIDENTD_DIR)/.unpacked
	(cd $(PIDENTD_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--sbindir=/usr/sbin \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(PIDENTD_DIR)/.configured

$(PIDENTD_DIR)/$(PIDENTD_BINARY): $(PIDENTD_DIR)/.configured
	$(MAKE) CC_FOR_BUILD=$(HOSTCC) -C $(PIDENTD_DIR)

$(TARGET_DIR)/$(PIDENTD_TARGET_BINARY): $(PIDENTD_DIR)/$(PIDENTD_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(PIDENTD_DIR) install
	sed -i -e 's,^PIDFILE=.*,PIDFILE=/var/run/identd.pid,' \
		-e 's,^IDENTD=.*,IDENTD=/usr/sbin/identd,' \
		$(PIDENTD_DIR)/etc/identd.init
	install -m0755 $(PIDENTD_DIR)/etc/identd.init $(TARGET_DIR)/etc/rc.d/init.d/identd
	install -m0644 $(PIDENTD_DIR)/etc/identd.conf $(TARGET_DIR)/etc
	install -d $(DOC_DIR)/doc/pidentd
	for f in doc/rfc1413.txt BUGS README ; do \
		install -m0644 $(PIDENTD_DIR)/$$f $(DOC_DIR)/doc/pidentd/`basename $$f` ;\
	done

pidentd: uclibc $(TARGET_DIR)/$(PIDENTD_TARGET_BINARY)

pidentd-clean:
	-for f in identd ibench idecrypt ikeygen ; do \
		rm -f $(TARGET_DIR)/usr/sbin/$$f || : ; \
	done
	-rm -f $(TARGET_DIR)/usr/man/man8/pidentd.8
	-rm -rf $(DOC_DIR)/doc/pidentd
	-$(MAKE) -C $(PIDENTD_DIR) clean

pidentd-dirclean:
	rm -rf $(PIDENTD_DIR)
endif

