/* Machine-dependent pthreads configuration and inline functions.
   FR-V version.
   Copyright (C) 2004  Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Alexandre Oliva <aoliva@redhat.com>

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If
   not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* This symbol is defined by the ABI as the stack size requested by
   the main program.  */
extern char __stacksize;
#define ARCH_STACK_DEFAULT_SIZE ((unsigned long)&__stacksize)

/* The ABI requires only 8-byte stack alignment.  */
#define STACK_ALIGN	8

/* Minimal stack size after allocating thread descriptor and guard size.  */
#define MINIMAL_REST_STACK	2048

/* Alignment requirement for TCB.  */
#define TCB_ALIGNMENT		16

/* Location of the current stack frame.  */
#define CURRENT_STACK_FRAME  __builtin_frame_address (0)

/* Return the thread descriptor for the current thread.  */
register void *__thread_pointer asm ("gr29");

/* XXX Until we have a better place keep the definitions here.  */

/* While there is no such syscall.  */
#define __exit_thread_inline(val) \
  INLINE_SYSCALL (exit, 1, (val))
