/* Special .init and .fini section support for FR-V.
   Copyright (C) 2003, 2004 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   In addition to the permissions in the GNU Lesser General Public
   License, the Free Software Foundation gives you unlimited
   permission to link the compiled version of this file with other
   programs, and to distribute those programs without any restriction
   coming from the use of this file.  (The GNU Lesser General Public
   License restrictions do apply in other respects; for example, they
   cover modification of the file, and distribution when not linked
   into another program.)

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

/* This file is compiled into assembly code which is then munged by a sed
   script into two files: crti.s and crtn.s.

   * crti.s puts a function prologue at the beginning of the .init and .fini
   sections and defines global symbols for those addresses, so they can be
   called as functions.

   * crtn.s puts the corresponding function epilogues in the .init and .fini
   sections.

   This differs from what would be generated by the generic code in
   that we preserve the GOT pointer in a specific stack location.  */

__asm__ ("						\n\
#include \"defs.h\"					\n\
							\n\
/*@HEADER_ENDS*/					\n\
							\n\
/*@_init_PROLOG_BEGINS*/				\n\
	.section .init,\"x\"				\n\
	.p2align 2					\n\
	.globl _init					\n\
	.weak __gmon_start__				\n\
	.type	_init, @function			\n\
_init:							\n\
	addi sp,#-16,sp					\n\
	st.p fp, @(sp,gr0)				\n\
	mov sp, fp					\n\
	movsg lr, gr5					\n\
	sti gr15, @(fp,4) 				\n\
	sti.p gr5, @(fp,8)				\n\
	call __pthread_initialize_minimal		\n\
/*@_init_PROLOG_ENDS*/					\n\
							\n\
/*@_init_EPILOG_BEGINS*/				\n\
	.section .init,\"x\"				\n\
	.globl _init					\n\
	.type	_init, @function			\n\
	ldi @(fp,8), gr5				\n\
	ld @(sp,gr0), fp				\n\
	addi sp,#16,sp					\n\
	jmpl @(gr5,gr0)					\n\
	.size	_init, .-_init				\n\
/*@_init_EPILOG_ENDS*/					\n\
							\n\
/*@_fini_PROLOG_BEGINS*/				\n\
	.section .fini,\"x\"				\n\
	.p2align 2					\n\
	.globl _fini					\n\
	.type	_fini, @function			\n\
_fini:							\n\
	addi sp,#-16,sp					\n\
	st.p fp, @(sp,gr0)				\n\
	mov sp, fp					\n\
	movsg lr, gr5					\n\
	sti gr15, @(fp,4)				\n\
	sti gr5, @(fp,8)				\n\
/*@_fini_PROLOG_ENDS*/					\n\
							\n\
/*@_fini_EPILOG_BEGINS*/				\n\
	.section .fini,\"x\"				\n\
	.globl _fini					\n\
	.type	_fini, @function			\n\
	ldi @(fp,8), gr5				\n\
	ld @(sp,gr0), fp				\n\
	addi sp,#16,sp					\n\
	jmpl @(gr5,gr0)					\n\
	.size	_fini, .-_fini				\n\
/*@_fini_EPILOG_ENDS*/					\n\
							\n\
/*@TRAILER_BEGINS*/					\n\
");
