/* Definitions for thread-local data handling.  linuxthreads/FR-V version.
   Copyright (C) 2002, 2003, 2004 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Alexandre Oliva <aoliva@redhat.com>
   based on the alpha version.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#ifndef _TLS_H
#define _TLS_H

#ifndef __ASSEMBLER__

# include <pt-machine.h>
# include <stddef.h>

/* Type for the dtv.  */
typedef union dtv
{
  size_t counter;
  void *pointer;
} dtv_t;


/* The ABI defines size and alignment as 16 bytes.  */
typedef struct __attribute__((__aligned__ (16)))
{
  dtv_t *dtv;

  /* Reserved for the thread implementation.  Unused in LinuxThreads.  */
  void *private;
} tcbhead_t;

struct __assert_tcbhead_t_size {
  char assert_check[sizeof(tcbhead_t) == 16 ? 1 : -1];
};
#endif


#ifdef HAVE_TLS_SUPPORT

/* Signal that TLS support is available.  */
# define USE_TLS	1

/* The TCB head is at @(gr29,-2048), so the TLS for the executable
   starts at gr29-2032.  */
#  define TP_BIAS 2048
#  define TLS_BIAS (TP_BIAS - TLS_TCB_SIZE)

# ifndef __ASSEMBLER__
/* Get system call information.  */
#  include <sysdep.h>

/* This is the size of the initial TCB.  */
#  define TLS_INIT_TCB_SIZE	sizeof (tcbhead_t)

/* Alignment requirements for the initial TCB.  */
#  define TLS_INIT_TCB_ALIGN	__alignof__ (tcbhead_t)

/* This is the size of the TCB.  */
#  define TLS_TCB_SIZE		sizeof (tcbhead_t)

/* Alignment requirements for the TCB.  */
#  define TLS_TCB_ALIGN		__alignof__ (tcbhead_t)

/* This is the size we need before TCB.  */
#  define TLS_PRE_TCB_SIZE	(sizeof (struct _pthread_descr_struct) + ((TLS_TCB_SIZE + TLS_PRE_TCB_ALIGN - 1) & ~(TLS_PRE_TCB_ALIGN - 1)) - TLS_TCB_SIZE)

/* This is the alignment we need before TCB.  */
#  define TLS_PRE_TCB_ALIGN     __alignof__ (struct _pthread_descr_struct)

/* If the offset between the beginning of the pre-TCB block and main
   executable TLS block must be constant, this macro is defined as
   such an offset.  There must be room for the pre-TCB area and the
   TCB area, all properly aligned.  */
#  define TLS_FIXED_EXEC_TCB_OFFSET_P 1

/* The DTV is allocated at the TP; the TCB is placed elsewhere.  */
#  define TLS_DTV_AT_TP 1

/* Install the dtv pointer.  The pointer passed is to the element with
   index -1 which contain the length.  */
#  define INSTALL_DTV(TCBP, DTVP) \
  (((tcbhead_t *) (TCBP))->dtv = (DTVP) + 1)

#  define TCB_FROM_TP(TP) ((tcbhead_t *)((unsigned long)(TP) - TP_BIAS))
#  define TP_FROM_TCB(TCBP) ((void*)((unsigned long)(TCBP) + TP_BIAS))

#  define THREAD_SELF_FROM_TCB(TCBP) \
     ((struct _pthread_descr_struct *)((unsigned long)(TCBP) \
				       - TLS_PRE_TCB_SIZE))
#  define TCB_FROM_THREAD_SELF(TS) \
     ((tcbhead_t *)((unsigned long)(TS) + TLS_PRE_TCB_SIZE))

#  define THREAD_SELF_FROM_TP(TP) (THREAD_SELF_FROM_TCB (TCB_FROM_TP (TP)))
#  define TP_FROM_THREAD_SELF(TS) (TP_FROM_TCB (TCB_FROM_THREAD_SELF (TS)))

/* Install new dtv for current thread.  */
#  define INSTALL_NEW_DTV(DTV) \
  ((TCB_FROM_TP (__thread_pointer))->dtv = (DTV))

/* Return dtv of given thread descriptor.  */
#  define GET_DTV(TCBP) \
  (((tcbhead_t *) (TCBP))->dtv)

/* Code to initially initialize the thread pointer.  This might need
   special attention since 'errno' is not yet available and if the
   operation can cause a failure 'errno' must not be touched.  */
# define TLS_INIT_TP(TCBP, SECONDCALL) \
  ((__thread_pointer = TP_FROM_TCB (TCBP)), (void*)0)

/* Return the address of the dtv for the current thread.  */
#  define THREAD_DTV() \
  ((TCB_FROM_TP (__thread_pointer))->dtv)

/* Return the thread descriptor for the current thread.  */
#  undef THREAD_SELF
#  define THREAD_SELF (THREAD_SELF_FROM_TP (__thread_pointer))

#  undef INIT_THREAD_SELF
#  define INIT_THREAD_SELF(DESCR, NR) \
  (__thread_pointer = (TP_FROM_THREAD_SELF (DESCR)))

/* Get the thread descriptor definition.  */
#  include <linuxthreads/descr.h>

/* ??? Generic bits of LinuxThreads may call these macros with
   DESCR set to NULL.  We are expected to be able to reference
   the "current" value.  */

#define THREAD_GETMEM(descr, member) \
  ((void) sizeof (descr), THREAD_SELF->member)
#define THREAD_SETMEM(descr, member, value) \
  ((void) sizeof (descr), THREAD_SELF->member = (value))

# endif	/* HAVE_TLS_SUPPORT */
#endif /* __ASSEMBLER__ */

#endif	/* tls.h */
