/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWLINEEDIT_H
#define WORKFLOWLINEEDIT_H

// KDE includes
#include <klineedit.h>

// WorKflow includes
#include "widgetinterface.h"

namespace WorKflow
{
  /**
   * @author Thomas Kadauke
   */
  class LineEdit : public KLineEdit, public WorKflow::WidgetInterface
  {
    Q_OBJECT
    Q_ENUMS(JoinType)
    Q_PROPERTY(QString parameterId READ parameterId WRITE setParameterId)
    Q_PROPERTY(JoinType joinType READ joinType WRITE setJoinType)
    Q_PROPERTY(QString joinString READ joinString WRITE setJoinString)
    Q_PROPERTY(QString splitExpression READ splitExpression WRITE setSplitExpression)

  public:
    enum JoinType {
      SingleItem,
      JoinString,
    };

    LineEdit(QWidget* parent, const char* name);
    LineEdit(const QString& string, QWidget* parent, const char* name);
    ~LineEdit();

    virtual Value value();

    virtual void setParameterId(const QString& paramId);
    virtual QString parameterId() const;

    JoinType joinType() const;
    void setJoinType(JoinType type);
    QString joinString() const;
    void setJoinString(const QString& str);
    QString splitExpression() const;
    void setSplitExpression(const QString& expression);

  public slots:
    virtual void setValue(const Value& value);

  signals:
    void changed(const Value& value);

  private slots:
    void slotChanged();

  private:
    class Private;
    Private* d;
  };
}

#endif
